% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halfcircle.R
\name{halfcircle}
\alias{halfcircle}
\title{Visualization method for flow data using halfcircle diagram}
\usage{
halfcircle(flow, node, dir = "horizontal", circle.col = "lightgray",
  circle.trans = 0.5, flow.col = "black", flow.trans = 0.5,
  flow.width = "proportional", node.color = "black", node.size = 0.1,
  node.pch = 20, node.trans = 0.7, label = node[, c(1)],
  label.size = 0.5, label.col = "black", label.gap = 0.1)
}
\arguments{
\item{flow}{a dataframe which is to draw half-circles. The data should be in the form of an edge list containing node of origin, node of destination, and magnitude of the flow on the first three columns.}

\item{node}{a dataframe which contains names of node on the first column. Nodes on the center line of a circle are drawn by the order of the data. Every node presented in flow data must be contained.}

\item{dir}{if 'horizontal' (the default), nodes are drawn along the X-axis. If 'vertical', nodes are drawn along the Y-axis.}

\item{circle.col}{color of background circle}

\item{circle.trans}{transparency of color of background circle}

\item{flow.col}{flow color. flow.col can be a list of color vectors, the vectors are then used per flow.}

\item{flow.trans}{transparency of color of flows}

\item{flow.width}{width of flows. if 'proportional' (the default), each width is calculated to be proportional to the maximum volume of flows. Maximum width is set to be 10. Otherwise, a list of width vectors can be used per flow.}

\item{node.color}{node color. It can be a list of color vectors, and the vectors are then used per node.}

\item{node.size}{node size}

\item{node.pch}{node type. see ?points for more options.}

\item{node.trans}{transparency of color of flows}

\item{label}{the first column of node, names, is represented (the default). a list of vector an be used per node. if NULL, no label is drawn.}

\item{label.size}{label size}

\item{label.col}{label color}

\item{label.gap}{gap between the node and the respective label}
}
\description{
halfcircle function draws flows between nodes creating halfcircle diagram.
}
\details{
This function is a low-level graphical function, and you will create a halfcircle diagram. To create the diagram, nodes are placed as a set of points on a straight line segment in the center of a circle. The flow between two nodes is represented using a half cicle drawn from the origin to the destination in a clockwise direction. It is virtually drawn on xy-coordinates where both x and y range from -1 to 1. Flows between the same nodes are not drawn.
}
\examples{
# load flow data
data(ex_flow)
flow <- ex_flow[,c(1,2,3)] # select veget column as volume
flow <- subset(flow,flow$vegetable>5000)
data(ex_node) # load node data
node <- ex_node[c(order(-ex_node$gdpc)),] # sort nodes in descending order of gdpc values
halfcircle(flow, node, dir="vertical", circle.col="gray", flow.col="black",label=NULL)

# legend
max <- max(flow[,c(3)]); median <- median(flow[,c(3)]); min <- min(flow[,c(3)])
max_w <- 10; median_w <- round(10*median/max); min_w <- round(10*min/max)
legend(x=-1.2, y=-0.8, legend=c(paste(round(max)), paste(round(median)), paste(round(min))),
    lty=1, lwd=c(max_w, median_w, min_w), cex=0.7)

# customize colors
node$color <- c("#22abcb","#4eb6ad","#86c388","#adcd6c","#dad84f")[node$income_level]
flow2 <- data.frame(flow, node[match(flow[,"O"], node[,"country"]),])
halfcircle(flow2, node, dir="vertical", flow.col=flow2$color, node.color=node$color, label=NULL)

# highlight one node
flow3 <- flow
flow3$color <- "gray"
flow3$color[flow3$O=="China"|flow3$D=="China"] <- "blue"
flow3 <- flow3[c(order(flow3$color,decreasing=TRUE)),]
node$label <- ""
node$label[node$country=="China"] <- "China"
halfcircle(flow3, node, dir="vertical", flow.col=flow3$color, label=node$label, label.size=0.7)
}
\references{
Xiao and Chun (2009) <doi:10.1559/152304009788188763>
}
\author{
Sohyun Park <park.2627@osu.edu>, Ningchuan Xiao
}
