% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_distance.R
\name{melt_dist}
\alias{melt_dist}
\title{Melt a square distance matrix into long format}
\usage{
melt_dist(dist, order = NULL, dist_name = "dist")
}
\arguments{
\item{dist}{An object of class matrix, it must be square}

\item{order}{A character vector of size n with the order of the columns and rows (default: NULL)}

\item{dist_name}{A string to name the distance column in the output (default: dist)}
}
\value{
A data.frame with three columns: (1) iso1; (2) iso2; (3) dist. iso1 and
iso2 indicate the pair being compared, and dist indicates the distance between
that pair.
}
\description{
This will take a square distance matrix, and will transform in to long
format. It will remove upper triangle, and diagonal elements, so you
end with only (n)*(n-1)/2 rows, where n are the total number of rows in
the distance matrix.
}
\examples{
\dontrun{
data(woodmouse)
dist <- ape::dist(woodmouse, model = 'N', as.matrix = TRUE)
dist_df <- melt_dist(dist)
}
}
