% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_desc.R
\docType{data}
\name{data_fhnorm}
\alias{data_fhnorm}
\title{Simulated Fay-Herriot Normal Data (Area-Level)}
\format{
A data frame with n rows and 8 variables:
\describe{
\item{y}{Observed direct estimator per area.}
\item{D}{Sampling variance for the direct estimator.}
\item{x1, x2, x3}{Auxiliary area-level covariates.}
\item{theta_true}{True latent mean parameter per area.}
\item{u}{Area-level random effect.}
\item{group}{Area ID (1–n) specifying the grouping structure.}
\item{sre}{Optional grouping factor mapping observations to spatial locations (e.g. regions).}
}
}
\source{
Simulated data based on the Fay-Herriot Normal model.
}
\usage{
data_fhnorm
}
\description{
The \code{data_fhnorm} dataset contains simulated data for n areas based on a
Fay-Herriot Normal model. It includes area-level covariates, true latent values,
direct estimators, sampling variances, and area random effects. This dataset is
intended for evaluating small area estimation models under normality assumptions.
}
\examples{
data(data_fhnorm)
head(data_fhnorm)
}
\keyword{datasets}
