% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_desc.R
\docType{data}
\name{data_lnln}
\alias{data_lnln}
\title{Simulation Data for Lognormal-Lognormal Model}
\format{
A data frame with 100 rows and 13 variables:
\describe{
\item{group}{Area ID (1–100) for random effects formula specifying the grouping structure in the data. }
\item{x1, x2, x3}{Auxiliary area-level covariates}
\item{u_true}{True unstructured area-level random effect on the log scale.}
\item{teta_true}{True linear predictor on the log scale (meanlog for lognormal distribution).}
\item{mu_orig_true}{True mean on the original scale, calculated from \code{eta_true} and \code{sigma_e}.}
\item{n}{Sample size per area.}
\item{y_obs}{Simulated observed mean per area, generated from a lognormal distribution.}
\item{lambda_dir}{Direct estimator of the mean per area (same as \code{y_obs}).}
\item{y_log_obs}{Log-transformed direct estimator.}
\item{psi_i}{Approximate sampling variance of \code{y_obs}.}
\item{sre}{An optional grouping factor mapping observations to spatial locations.}
}
}
\source{
Simulated data based on a Lognormal–Lognormal model.
}
\usage{
data_lnln
}
\description{
This dataset is a simulated data created for demonstrating the implementation of
\emph{Hierarchical Bayesian Small Area Estimation} (HB SAE) using a \strong{lognormal-lognormal model}.
It includes area-level covariates, random effects, direct estimates, and spatial components,
for testing SAE models with lognormal assumptions and spatial correlation.
}
\keyword{datasets}
