% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paf.R
\name{paf}
\alias{paf}
\title{Population attributable fraction (PAF)}
\usage{
paf(
  est,
  pop = NULL,
  favourable_indicator,
  ordered_dimension,
  subgroup_order = NULL,
  setting_average = NULL,
  scaleval,
  conf.level = 0.95,
  force = FALSE,
  ...
)
}
\arguments{
\item{est}{The subgroup estimate. Estimates must be available for the two
subgroups being compared.}

\item{pop}{The number of people within each subgroup.Population size must be
available for all subgroups.}

\item{favourable_indicator}{Records whether the indicator is favourable (1)
or adverse (0). Favourable indicators measure desirable health events where
the ultimate goal is to achieve a maximum level (such as skilled birth
attendance). Adverse indicators measure undesirable health events where the
ultimate goal is to achieve a minimum level (such as under-five mortality
rate).}

\item{ordered_dimension}{Records whether the dimension is ordered (1) or
non-ordered (0). Ordered dimensions have subgroup with a natural order (such
as economic status). Non-ordered or binary dimensions do not have a natural
order (such as subnational region or sex).}

\item{subgroup_order}{The order of subgroups in an increasing sequence.
Required if the dimension is ordered (ordered_dimension=1).}

\item{setting_average}{The overall indicator average for the setting of
interest. Setting average must be unique for each setting, year and indicator
combination. If population (pop) is not specified for all subgroups, the
setting average is used for the calculation.}

\item{scaleval}{The scale of the indicator. For example, the scale of an
indicator measured as a percentage is 100. The scale of an indicator measured
as a rate per 1000 population is 1000.}

\item{conf.level}{Confidence level of the interval. Default is 0.95 (95\%).}

\item{force}{TRUE/FALSE statement to force calculation when subgroup
estimates are missing.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated PAF value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
Population attributable fraction (PAR) is a relative measure of inequality
that shows the potential improvement in the average of an indicator, in
absolute terms, that could be achieved if all population subgroups had
the same level of the indicator as a reference point. The reference point
refers to the most advantaged subgroup for ordered dimensions and the
best-performing subgroup for non-ordered dimensions (i.e. the subgroup with
the highest value for favourable indicators and the subgroup with the lowest
value for adverse indicators).
}
\details{
PAF is calculated as the difference between the estimate for the
reference subgroup and the mean (e.g. the national average), divided by the
mean and multiplied by 100. For more information on this inequality
measure see Schlotheuber (2022) below.

If the indicator is favourable and PAF < 0, then PAF is replaced with 0.
If the indicator is adverse and PAF > 0, then PAF is replaced with 0.

\strong{Interpretation:} PAF assumes positive values for favourable indicators
and negative values for non-favourable (adverse) indicators. The larger the
absolute value of PAF, the higher the level of inequality. PAF is 0 if no
further improvement can be achieved (i.e., if all subgroups have reached
the same level of the indicator as the reference subgroup or surpassed that
level).

\strong{Type of summary measure:} Complex; relative; weighted

\strong{Applicability:} Any dimension of inequality with more than two subgroups

\strong{Warning:} The confidence intervals are approximate and might be biased.
See Walter S.D. (1978) below for further information on the standard error
formula.
}
\examples{
# example code
data(OrderedSample)
head(OrderedSample)
with(OrderedSample,
     paf(est = estimate,
            pop = population,
            favourable_indicator = favourable_indicator,
            ordered_dimension = ordered_dimension,
            subgroup_order = subgroup_order,
            scaleval = indicator_scale))
}
\references{
Schlotheuber, A, Hosseinpoor, AR. Summary measures of health
inequality: A review of existing measures and their application. Int J
Environ Res Public Health. 2022;19(6):3697. doi:10.3390/ijerph19063697.

Walter, SD. Calculation of attributable risks from
epidemiological data. Int J Epidemiol. 1978 Jun 1;7(2):175-82.
doi:10.1093/ije/7.2.175.
}
