% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-feature-cluster-tbl.R
\name{ts_feature_cluster}
\alias{ts_feature_cluster}
\title{Time Series Feature Clustering}
\usage{
ts_feature_cluster(
  .data,
  .date_col,
  .value_col,
  ...,
  .features = c("frequency", "entropy", "acf_features"),
  .scale = TRUE,
  .prefix = "ts_",
  .centers = 3
)
}
\arguments{
\item{.data}{The data passed must be a \code{data.frame/tibble} only.}

\item{.date_col}{The date column.}

\item{.value_col}{The column that holds the value of the time series where you
want the features and clustering performed on.}

\item{...}{This is where you can place grouping variables that are passed off
to \code{dplyr::group_by()}}

\item{.features}{This is a quoted string vector using c() of features that you
would like to pass. You can pass any feature you make or those from the \code{tsfeatures}
package.}

\item{.scale}{If TRUE, time series are scaled to mean 0 and sd 1 before features are computed}

\item{.prefix}{A prefix to prefix the feature columns. Default: "ts_"}

\item{.centers}{An integer of how many different centers you would like to generate.
The default is 3.}
}
\value{
A list output
}
\description{
This function returns an output list of data and plots that
come from using the \code{K-Means} clustering algorithm on a time series data.
}
\details{
This function will return a list object output. The function itself
requires that a time series tibble/data.frame get passed to it, along with
the \code{.date_col}, the \code{.value_col} and a period of data. It uses the underlying
function \code{timetk::tk_tsfeatures()} and takes the output of that and performs
a clustering analysis using the \code{K-Means} algorithm.

The function has a parameter of \code{.features} which can take any of the features
listed in the \code{tsfeatures} package by Rob Hyndman. You can also create custom
functions in the \code{.GlobalEnviron} and it will take them as quoted arguments.

So you can make a function as follows

\code{my_mean <- function(x){return(mean(x, na.rm = TRUE))}}

You can then call this by using \code{.features = c("my_mean")}.

The output of this function includes the following:

\strong{Data Section}
\itemize{
\item ts_feature_tbl
\item user_item_matrix_tbl
\item mapped_tbl
\item scree_data_tbl
\item input_data_tbl (the original data)
}

\strong{Plots}
\itemize{
\item static_plot
\item plotly_plot
}
}
\examples{

library(dplyr)

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  mutate(group_id = rep(1:12, 12))

ts_feature_cluster(
  .data = data_tbl,
  .date_col = date_col,
  .value_col = value,
  group_id,
  .features = c("acf_features","entropy"),
  .scale = TRUE,
  .prefix = "ts_",
  .centers = 3
)

}
\seealso{
\url{https://pkg.robjhyndman.com/tsfeatures/index.html}

Other Clustering: 
\code{\link{ts_feature_cluster_plot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Clustering}
