% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap3.R
\name{heatmap3}
\alias{heatmap3}
\title{heatmap3}
\usage{
heatmap3(
  x,
  Rowv = NULL,
  Colv = if (symm) "Rowv" else NULL,
  distfun = function(x) as.dist(1 - cor(t(x), use = "pa")),
  distfunC,
  distfunR,
  balanceColor = F,
  ColSideLabs,
  RowSideLabs,
  showColDendro = T,
  showRowDendro = T,
  col = colorRampPalette(c("navy", "white", "firebrick3"))(1024),
  legendfun,
  method = "complete",
  ColAxisColors = 0,
  RowAxisColors = 0,
  hclustfun = hclust,
  reorderfun = function(d, w) reorder(d, w),
  add.expr,
  symm = FALSE,
  revC = identical(Colv, "Rowv"),
  scale = c("row", "column", "none"),
  na.rm = TRUE,
  ColSideFun,
  ColSideAnn,
  ColSideWidth = 0.4,
  ColSideCut,
  colorCell,
  highlightCell,
  file = "heatmap3.pdf",
  topN = NA,
  filterFun = sd,
  returnDistMatrix = FALSE,
  margins = c(5, 5),
  ColSideColors,
  RowSideColors,
  cexRow = 0.2 + 1/log10(nrow(x)),
  cexCol = 0.2 + 1/log10(ncol(x)),
  lasRow = 2,
  lasCol = 2,
  labRow = NULL,
  labCol = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  keep.dendro = FALSE,
  verbose = getOption("verbose"),
  useRaster = if (ncol(x) * nrow(x) >= 50000) TRUE else FALSE,
  ...
)
}
\arguments{
\item{x}{numeric matrix of the values to be plotted. }

\item{Rowv}{determines if and how the \emph{row} dendrogram should be
    computed and reordered.  Either a \code{\link[stats]{dendrogram}} or a
    vector of values used to reorder the row dendrogram or
    \code{\link{NA}} to suppress any row dendrogram (and reordering) or
    by default, \code{\link{NULL}}, see \sQuote{Details} below.}

\item{Colv}{determines if and how the \emph{column} dendrogram should be
    reordered.  Has the same options as the \code{Rowv} argument above and
    \emph{additionally} when \code{x} is a square matrix, \code{Colv =
      "Rowv"} means that columns should be treated identically to the
    rows (and so if there is to be no row dendrogram there will not be a
    column one either).}

\item{distfun}{function used to compute the distance (dissimilarity)
    between both rows and columns.  Defaults to \code{\link[stats]{dist}}.}

\item{distfunC}{function used to compute the distance (dissimilarity) between and columns. Will be the same as distfun if not specified.}

\item{distfunR}{function used to compute the distance (dissimilarity) between and rows. Will be the same as distfun if not specified.}

\item{balanceColor}{logical indicating if the colors need to be balanced so that the median color will represent the 0 value. The default value is F.}

\item{ColSideLabs}{label for ColSideColors}

\item{RowSideLabs}{label for RowSideColors}

\item{showColDendro}{logical indicating if the coloum dendrogram should be plotted (when Colv isn't NA).}

\item{showRowDendro}{logical indicating if the row dendrogram should be plotted (when Rowv isn't NA).}

\item{col}{specifying the colors, used in \code{\link{image}} function.}

\item{legendfun}{function used to generate legend in top left of the figure. If not specified, the color bar will be plotted. The users can use any plot functions to generate their own legend. Or a function \code{\link{showLegend}} is also provided as a example.}

\item{method}{the agglomeration method to be used by \code{\link{hclust}} function. This should be (an unambiguous abbreviation of) one of "ward", "single", "complete", "average", "mcquitty", "median" or "centroid".}

\item{ColAxisColors}{integer indicating which coloum of ColSideColors will be used as colors for labels in coloum axis. The default value is 0, which means all coloum labels will be in black color.}

\item{RowAxisColors}{integer indicating which coloum of RowSideColors will be used as colors for labels in row axis. The default value is 0, which means all row labels will be in black color.}

\item{hclustfun}{function used to compute the hierarchical clustering
    when \code{Rowv} or \code{Colv} are not dendrograms.  Defaults to
    \code{\link[stats]{hclust}}. Should take as argument a result of \code{distfun}
    and return an object to which \code{\link[stats]{as.dendrogram}} can be applied.}

\item{reorderfun}{\code{function(d, w)} of dendrogram and weights for
    reordering the row and column dendrograms.  The default uses
    \code{\link[stats]{reorder.dendrogram}}.}

\item{add.expr}{expression that will be evaluated after the call to
    \code{image}.  Can be used to add components to the plot.}

\item{symm}{logical indicating if \code{x} should be treated
    \bold{symm}etrically; can only be true when \code{x} is a square matrix.}

\item{revC}{logical indicating if the column order should be
    \code{\link{rev}}ersed for plotting, such that e.g., for the
    symmetric case, the symmetry axis is as usual.}

\item{scale}{character indicating if the values should be centered and
    scaled in either the row direction or the column direction, or
    none.  The default is \code{"row"} if \code{symm} false, and
    \code{"none"} otherwise.}

\item{na.rm}{logical indicating whether \code{NA}'s should be removed.}

\item{ColSideFun}{function used to generate annotation and labeling figure in column side. The users can use any plot functions to generate their own figure. And a function \code{\link{showAnn}} is also provided as a example.}

\item{ColSideAnn}{data frame with continuous and factor variables as annotation information. This parameter will be sorted by coloum dendrogram and then passed to ColSideFun.}

\item{ColSideWidth}{numeric the height of column side area, which can be used by ColSideFun function.}

\item{ColSideCut}{numeric the value to be used in cutting coloum dendrogram. The dendrogram and annotation will be divided into different parts and labeled respectively.}

\item{colorCell}{A data.frame with 3 columns, indicating which cells will be colored by specific colors. The first column is row index, second column is column index, and the third column is color.}

\item{highlightCell}{A data.frame with 3 or 4 columns, indicating which cells will be highlighted by rectangles with specific colors. The first column is row index, second column is column index, the third column is color for rectangle border, and the optional forth column is width for rectangle border.}

\item{file}{pdf file name, only works when topN was used.}

\item{topN}{vector a list of numbers. topN genes will be used to generate the heatmaps.}

\item{filterFun}{function used to filter genes, such as sd, mean, sum. It will be used in a apply function to caculate for each row.}

\item{returnDistMatrix}{logical indicating if the distance matrix will be returned}

\item{margins}{numeric vector of length 2 containing the margins
    (see \code{\link{par}(mar = *)}) for column and row names, respectively.}

\item{ColSideColors}{(optional) character vector of length \code{ncol(x)}
    containing the color names for a horizontal side bar that may be used to
    annotate the columns of \code{x}.}

\item{RowSideColors}{(optional) character vector of length \code{nrow(x)}
    containing the color names for a vertical side bar that may be used to
    annotate the rows of \code{x}.}

\item{cexRow, cexCol}{positive numbers, used as cex.axis in for the row or column axis labeling. The defaults currently only use number of rows or columns, respectively.}

\item{lasRow, lasCol}{the style of row or column axis labels.}

\item{labRow, labCol}{character vectors with row and column labels to use; these default to rownames(x) or colnames(x), respectively.}

\item{main, xlab, ylab}{main, x- and y-axis titles; defaults to none.}

\item{keep.dendro}{logical indicating if the dendrogram(s) should be
    kept as part of the result (when \code{Rowv} and/or \code{Colv} are
    not NA).}

\item{verbose}{logical indicating if information should be printed.}

\item{useRaster}{logical; if TRUE a bitmap raster is used to plot the image instead of polygons. The grid must be regular in that case, otherwise an error is raised.}

\item{...}{additional arguments passed on to \code{\link{image}}.}
}
\value{
The same return value as \code{\link{hclust}} function.
}
\description{
The function heatmap3 is completely compatible with the original R function heatmap, and provides more new features.
}
\examples{
#gererate data
set.seed(123456789)
rnormData<-matrix(rnorm(1000), 40, 25)
rnormData[1:15, seq(6, 25, 2)] = rnormData[1:15, seq(6, 25, 2)] + 2
rnormData[16:40, seq(7, 25, 2)] = rnormData[16:40, seq(7, 25, 2)] + 4
colnames(rnormData)<-c(paste("Control", 1:5, sep = ""), 
paste(c("TrtA", "TrtB"), rep(1:10,each=2), sep = ""))
rownames(rnormData)<-paste("Probe", 1:40, sep = "")
ColSideColors<-cbind(Group1=c(rep("steelblue2",5), rep(c("brown1", 
    "mediumpurple2"),10)),Group2=sample(c("steelblue2","brown1", 
    "mediumpurple2"),25,replace=TRUE))
colorCell<-data.frame(row=c(1,3,5),col=c(2,4,6),color=c("green4",
    "black","orange2"),stringsAsFactors=FALSE)
highlightCell<-data.frame(row=c(2,4,6),col=c(1,3,5),color=c("black",
    "green4","orange2"),lwd=1:3,stringsAsFactors=FALSE)
#A simple example
heatmap3(rnormData,ColSideColors=ColSideColors,showRowDendro=FALSE,
    colorCell=colorCell,highlightCell=highlightCell)
#A more detail example
ColSideAnn<-data.frame(Information=rnorm(25),Group=c(rep("Control",5),
    rep(c("TrtA","TrtB"),10)),stringsAsFactors=TRUE)
row.names(ColSideAnn)<-colnames(rnormData)
RowSideColors<-colorRampPalette(c("chartreuse4", "white", 
    "firebrick"))(40)
result<-heatmap3(rnormData,ColSideCut=1.2,ColSideAnn=ColSideAnn,
    ColSideFun=function(x) showAnn(x),ColSideWidth=0.8,
    RowSideColors=RowSideColors,col=colorRampPalette(c("green","black"
    , "red"))(1024),RowAxisColors=1,legendfun=function() 
    showLegend(legend=c("Low","High"),col=c("chartreuse4","firebrick"))
    ,verbose=TRUE)
#annotations distribution in different clusters and the result 
#of statistic tests
result$cutTable
}
