% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meat.heckmanGE.R
\name{meat.heckmanGE}
\alias{meat.heckmanGE}
\title{meat.heckmanGE
Compute Meat of the Covariance Matrix for the Generalized Heckman Model}
\usage{
meat.heckmanGE(x, adjust = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{heckmanGE}. This object should be a fitted model for which the covariance matrix is to be computed.}

\item{adjust}{A logical value indicating whether to apply a small-sample correction to the covariance matrix. If \code{TRUE}, the matrix is adjusted by multiplying it by \code{n / (n - k)}, where \code{n} is the number of observations and \code{k} is the number of parameters.}

\item{...}{Additional arguments passed to \code{estfun.heckmanGE}, which computes the estimating functions used in the calculation.}
}
\value{
A matrix representing the "meat" of the covariance matrix. The dimensions and row/column names of the matrix correspond to the number of parameters in the model.
}
\description{
This function calculates the "meat" of the covariance matrix for a \code{heckmanGE} model. The "meat" refers to the part of the covariance matrix that is not accounted for by the model's fixed components. This is typically used in conjunction with the "bread" component to form a robust covariance matrix estimator.
}
\details{
\itemize{
\item The function calculates the covariance matrix based on the estimating functions obtained from \code{estfun.heckmanGE}.
\item The "meat" is calculated as the cross-product of the estimating functions, divided by the number of observations. If \code{adjust} is \code{TRUE}, a small-sample correction is applied.
}
}
