% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_univar.R
\name{dens.hermite_estimator_univar}
\alias{dens.hermite_estimator_univar}
\title{Estimates the probability density for a vector of x values}
\usage{
\method{dens}{hermite_estimator_univar}(h_est_obj, x, clipped = FALSE, accelerate_series = TRUE)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_univar object.}

\item{x}{A numeric vector. Values at which to estimate the probability
density.}

\item{clipped}{A boolean value. This value determines whether
probability densities are clipped to be bigger than zero.}

\item{accelerate_series}{A boolean value. This value determines whether
Hermite series acceleration is applied.}
}
\value{
A numeric vector of probability density values.
}
\description{
This method calculates the probability density values at a vector of
x values using the hermite_estimator_univar object (h_est_obj).
}
\details{
The object must be updated with observations prior to the use of the method.
}
