% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hero.R, R/plot.hero_numeric.R
\name{plot.hero_matrix}
\alias{plot.hero_matrix}
\alias{plot.hero_numeric}
\title{Plot a \code{hero} object}
\usage{
\method{plot}{hero_matrix}(x, xlab = "", ylab = "", ...)

\method{plot}{hero_numeric}(x, xlab = "", ylab = "", type = "l", ...)
}
\arguments{
\item{x}{An object of class \code{hero}.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{...}{Additional graphical parameters passed to the
relevant plotting function.  See Details.}

\item{type}{The plot type (when \code{x} is of subclass
\code{hero_numeric}).  Default is \code{type = "l"}.}
}
\description{
Plot the smoothed data produced by the
\code{\link{hero}}
function.  The behavior of the function changes depending
on the subclass of the \code{hero} object.  See Details.
}
\details{
If \code{x} has subclass \code{hero_numeric}, then
the traditional \code{\link[graphics]{plot}} function
is used to plot the smoothed data, with \code{type = "l"}.

If \code{x} has subclass \code{hero_matrix}, then
\code{\link[graphics]{image}} is used to plot the
smoothed data, or if the autoimage package is installed,
\code{\link[autoimage]{autoimage}} is used to
plot the smoothed data.
}
\examples{
# create b-splines
x1 = bspline(nbasis = 10)
x2 = bspline(nbasis = 12)

# observed data locations
evalarg1 = seq(0, 1, len = 60)
evalarg2 = seq(0, 1, len = 80)

# construct "true" data
mu = matrix(0, nrow = 60, ncol = 80)
for(i in seq_len(60)) {
   for(j in seq_len(80)) {
      mu[i, j] =  sin(2*pi*(evalarg1[i]-.5)^3)*cos(4*pi*evalarg2[j])
   }
}
# construct noisy data
data = mu + rnorm(60 * 80)

obj = prepare(data, list(evalarg1, evalarg2), list(x1, x2))
obj = enhance(obj)
sandmod = hero(obj)
plot(sandmod)
}
\seealso{
\code{\link{hero}}
}
