% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuals.R
\name{plot.HierarchicalSet}
\alias{plot.HierarchicalSet}
\title{Visualize hierarchical sets}
\usage{
\method{plot}{HierarchicalSet}(
  x,
  label = TRUE,
  type = "dendrogram",
  transform = NULL,
  style = theme_bw(),
  quantiles = 0,
  upperBound = 1,
  tension = 0.8,
  alpha = 1,
  circular = TRUE,
  showHierarchy = !circular,
  evenHierarchy = circular,
  outliers = NULL,
  ratio = NULL,
  n = 50,
  ...
)
}
\arguments{
\item{x}{A HierarchicalSet object to plot.}

\item{label}{logical. Should sets be labeled.}

\item{type}{The type of plot to produce. See detail. The name of the type may
be abbreviated.}

\item{transform}{A string giving the scale transformation or a
\code{\link[scales:trans_new]{scales::trans()}} object.}

\item{style}{A ggplot2 theme to use as basis for the plot. Defaults to
theme_bw().}

\item{quantiles}{The quantiles to split outlying elements up in for
outlying_elements plot. If length is above one a facetted plot will be
produced.}

\item{upperBound}{The upper quantile threshold to include. Defaults to 1
(i.e. everything is included)}

\item{tension}{The tension used for the hierarchical edge bundles in
outlying_elements plot. Defaults to 0.8}

\item{alpha}{The alpha level for the edge bundles. Defaults to 1}

\item{circular}{Logical. Should the hierarchical edge bundles be laid out in
a circular layout.}

\item{showHierarchy}{Logical. For intersectionStack plots, should a
dendrogram mapping union sizes be drawn above the icicle plot. For
outlying_elements plots should a dendrogram be plotted below (for circular) or
to the left (for linear) of the edge bundles.}

\item{evenHierarchy}{Logical. Should the heights of the dendrogram used for
constructing the edge bundles be evened out.}

\item{outliers}{A precomputed data.frame with outlier information, as
returned by \code{\link[=outlying_elements]{outlying_elements()}}.}

\item{ratio}{Should outliers be plotted as a ratio instead of the raw number.
If \code{NULL} the raw number is used, If \code{"min"} the raw number is
divided by the number of elements in the smallest set of the pair, if
\code{"max"} the largest set, and if \code{"mean"} the mean pair size.}

\item{n}{The number of coordinates to calculate for each edge in the
outlyingElements plot.}

\item{...}{Currently ignored}
}
\value{
A gtable object invisibly. This function is mainly called for the
side effect of creating a plot.
}
\description{
This is the main visualization interface to HierarchicalSet object. By
changing the type argument you control which types of plots are produced. See
datails for a walkthrough of the different plot types. All plots are based on
ggplot2 but heavily modified using gtable. Because of this the return value
is always a gtable object, so it is not possible to add additional geoms, or
change scales etc. on the result of \code{plot()}.
}
\details{
Currently 4 different plottypes are available:

\describe{
\item{\strong{dendrogram}}{Plots a horizontal dendrogram with the x-value
mapped to the intersection size divided by the union size. This plot very
clearly shows the rise in heterogenity as more and more sets are joined,
and clearly shows clusters of very similar sets.}
\item{\strong{intersectStack}}{Plots a bottom-up icicleplot with height
showing the size of the intersection. In essence this plot communicates the
same type of information as a Venn-diagram, but in a scalable way and only
showing the intersections along the hierarchy. Box color maps to the degree
(number of sets) of the intersection making high-degree high-intersection
as well as low-degree low-intersection boxes stand out.}
\item{\strong{heatmap}}{Plots a traditional heatmap showing all 2-degree
intersections. The sets are organized according to the hierarchy so the
result should show a number of squares along the diagonal. If two very
similar sets have been forced apart by the clustering, this will show up
nicely as high value squares away from the diagonal.}
\item{\strong{composite}}{Combines dendrogram, intersectStack and heatmap
into a composite plot.}
\item{\strong{outlyingElements}}{Plots intersects between two sets that are
missing from the intersect of their shared top node as hierarchical edge
bundles. It helps detect deviations from the global structure as defined
by the hierarchcial clustering.}
}
}
