% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.fst.R
\name{pairwise.betas}
\alias{pairwise.betas}
\title{Estimates pairwise betas according to Weir and Goudet (2017)}
\usage{
pairwise.betas(dat,diploid=TRUE)
}
\arguments{
\item{dat}{A data frame containing population of origin as the first column 
and multi-locus genotypes in following columns}

\item{diploid}{whether the data is from a diploid (default) or haploid organism}
}
\value{
a matrix of pairwise betas
}
\description{
Estimates pairwise betas according to Weir and Goudet (2017)
}
\examples{

data(gtrunchier)
pairwise.betas(gtrunchier[,-2],diploid=TRUE)

}
\author{
Jerome Goudet \email{jerome.goudet@unil.ch}

\href{https://academic.oup.com/genetics/article/206/4/2085/6072590}{Weir, BS and Goudet J. 2017} A Unified Characterization 
of Population Structure and Relatedness. Genetics (2017) 206:2085
}
