% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hint_single_urn.R
\name{Hyperdistinct}
\alias{Hyperdistinct}
\alias{dhydist}
\alias{phydist}
\alias{qhydist}
\alias{rhydist}
\title{Drawing Distinct Categories from a Single Urn}
\usage{
dhydist(n, a, q, range = NULL, log = FALSE)

phydist(n, a, q, vals, upper.tail = TRUE, log.p = FALSE)

qhydist(p, n, a, q, upper.tail = TRUE, log.p = FALSE)

rhydist(num = 5, n, a, q)
}
\arguments{
\item{n}{An integer specifying the number of categories in the urn.}

\item{a}{An integer specifying the number of balls drawn from the urn.}

\item{q}{An integer specifying the number of categories in the urn which have duplicate members.}

\item{range}{A vector of integers specifying the intersection sizes for which probabilities (dhydist) or cumulative probabilites (phydist) should be computed (can be a single number). If range is NULL (default) then probabilities will be returned over the entire range of possible values.}

\item{log}{Logical. If TRUE, probabilities p are given as log(p). Defaults to FALSE.}

\item{vals}{A vector of integers specifying the intersection sizes for which probabilities (dhydist) or cumulative probabilites (phydist) should be computed (can be a single number). If range is NULL (default) then probabilities will be returned over the entire range of possible values.}

\item{upper.tail}{Logical. If TRUE, probabilities are P(X >= c), else P(X <= c). Defaults to TRUE.}

\item{log.p}{Logical. If TRUE, probabilities p are given as log(p). Defaults to FALSE.}

\item{p}{A probability between 0 and 1.}

\item{num}{An integer specifying the number of random numbers to generate. Defaults to 5.}
}
\description{
Density, distribution function, quantile function and random generation for the distribution of distinct categories drawn from a single urn in which there are duplicates in q of the categories.
}
\examples{
## Generate the distribution of distinct categories drawn from a single urn.
dd <- dhydist(20, 10, 12)
## Restrict the range of intersections.
dd <- dhydist(20, 10, 12, range = 5:10)
## Generate cumulative probabilities.
pp <- phydist(29, 15, 8, vals = 5)
pp <- phydist(29, 15, 8, vals = 2, upper.tail = FALSE)
## Extract quantiles:
qq <- qhydist(0.15, 23, 12, 10)
## Generate random samples based on this distribution.
rr <- rhydist(num = 10, 18, 9, 12)
}
