% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_mbb_wp.R
\name{espn_mbb_wp}
\alias{espn_mbb_wp}
\title{\strong{Men's College Basketball win probability chart data from ESPN}}
\usage{
espn_mbb_wp(game_id)
}
\arguments{
\item{game_id}{(\emph{Integer} required): Game ID filter for querying a single game}
}
\value{
\code{\link[=espn_mbb_wp]{espn_mbb_wp()}} - A data frame with 9 variables:
\describe{
\item{\code{game_id}: character.}{Referencing game ID (should be same as \code{game_id} from other functions).}
\item{\code{play_id}: character.}{Referencing play ID.}
\item{\code{period}: integer.}{Clock (time) left in the game.}
\item{\code{time_left}: character.}{Clock (time) left in the game.}
\item{\code{period_seconds_left}: integer.}{Seconds left in the period.}
\item{\code{game_seconds_left}: integer.}{Seconds left in the game.}
\item{\code{home_win_percentage}: double.}{The probability of the home team winning the game.}
\item{\code{away_win_percentage}: double.}{The probability of the away team winning the game (calculated as 1 - \code{home_win_percentage} - \code{tie_percentage}).}
\item{\code{tie_percentage}: double.}{The probability of the game ending the final period in a tie.}
}
}
\description{
\strong{Men's College Basketball win probability chart data from ESPN}
}
\examples{
\donttest{
  espn_mbb_wp(game_id = 401256760)
}

}
\seealso{
Other ESPN MBB Functions: 
\code{\link{espn_mbb_betting}()},
\code{\link{espn_mbb_conferences}()},
\code{\link{espn_mbb_game_all}()},
\code{\link{espn_mbb_game_rosters}()},
\code{\link{espn_mbb_pbp}()},
\code{\link{espn_mbb_player_box}()},
\code{\link{espn_mbb_player_stats}()},
\code{\link{espn_mbb_rankings}()},
\code{\link{espn_mbb_scoreboard}()},
\code{\link{espn_mbb_standings}()},
\code{\link{espn_mbb_team_box}()},
\code{\link{espn_mbb_team_stats}()},
\code{\link{espn_mbb_teams}()}
}
\concept{ESPN MBB Functions}
\keyword{Chart}
\keyword{Data}
\keyword{MBB}
\keyword{Probability}
\keyword{Win}
