% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team.R
\name{nba_teamdetails}
\alias{nba_teamdetails}
\title{\strong{Get NBA Stats API Team Details}}
\usage{
nba_teamdetails(team_id = "1610612749", ...)
}
\arguments{
\item{team_id}{Team ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamAwardsChampionships,
TeamAwardsConf, TeamAwardsDiv, TeamBackground,
TeamHistory, TeamHof, TeamRetired, TeamSocialSites

\strong{TeamBackground}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   ABBREVIATION \tab character \cr
   NICKNAME \tab character \cr
   YEARFOUNDED \tab character \cr
   CITY \tab character \cr
   ARENA \tab character \cr
   ARENACAPACITY \tab character \cr
   OWNER \tab character \cr
   GENERALMANAGER \tab character \cr
   HEADCOACH \tab character \cr
   DLEAGUEAFFILIATION \tab character \cr
}


\strong{TeamHistory}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   CITY \tab character \cr
   NICKNAME \tab character \cr
   YEARFOUNDED \tab character \cr
   YEARACTIVETILL \tab character \cr
}


\strong{TeamSocialSites}\tabular{ll}{
   col_name \tab types \cr
   ACCOUNTTYPE \tab character \cr
   WEBSITE_LINK \tab character \cr
}


\strong{TeamAwardsChampionships}\tabular{ll}{
   col_name \tab types \cr
   YEARAWARDED \tab character \cr
   OPPOSITETEAM \tab character \cr
}


\strong{TeamAwardsConf}\tabular{ll}{
   col_name \tab types \cr
   YEARAWARDED \tab integer \cr
   OPPOSITETEAM \tab integer \cr
}


\strong{TeamAwardsDiv}\tabular{ll}{
   col_name \tab types \cr
   YEARAWARDED \tab integer \cr
   OPPOSITETEAM \tab integer \cr
}


\strong{TeamHof}\tabular{ll}{
   col_name \tab types \cr
   PLAYERID \tab character \cr
   PLAYER \tab character \cr
   POSITION \tab character \cr
   JERSEY \tab character \cr
   SEASONSWITHTEAM \tab character \cr
   YEAR \tab character \cr
}


\strong{TeamRetired}\tabular{ll}{
   col_name \tab types \cr
   PLAYERID \tab character \cr
   PLAYER \tab character \cr
   POSITION \tab character \cr
   JERSEY \tab character \cr
   SEASONSWITHTEAM \tab character \cr
   YEAR \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Details}

\strong{Get NBA Stats API Team Details}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teamdetails(team_id = '1610612749')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()},
\code{\link{nba_teamestimatedmetrics}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamelog}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teaminfocommon}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{NBA Team Functions}
