% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-restore.r
\name{restore}
\alias{restore}
\alias{restore,marray-method}
\alias{restore,mmatrix-method}
\alias{restore,mvector-method}
\title{Restore memory-mapped matrix}
\usage{
restore(object)

\S4method{restore}{marray}(object)

\S4method{restore}{mmatrix}(object)

\S4method{restore}{mvector}(object)
}
\arguments{
\item{object}{a memory mapped matrix}
}
\value{
a memory-mapped object
}
\description{
When the external pointer is broken, 
attempt to recreate a valid object, if the file still exists.
}
\examples{
a <- matrix(1:24, 4, 6)
A <- as.mmatrix(a, "float")
rdsfile <- tempfile(fileext = ".rds")
saveRDS(A, rdsfile)
A <- readRDS(rdsfile)
A
A <- restore(A)
A

}
