% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hover_action_button.R
\name{hover_action_button}
\alias{hover_action_button}
\title{Action button with button and icon animations}
\source{
\url{https://github.com/IanLunn/Hover}
}
\usage{
hover_action_button(
  inputId,
  label,
  icon = NULL,
  button_animation = NULL,
  icon_animation = NULL,
  width = NULL,
  ...
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{The contents of the button or link–usually a text label, but you could also use any other HTML, like an image.}

\item{icon}{An optional icon() to appear on the button.}

\item{button_animation}{The name of the button animation.}

\item{icon_animation}{The name of the icon animation.}

\item{width}{The width of the input, e.g. '400px', or '100\%'; see validateCssUnit().}

\item{...}{Named attributes to be applied to the button or link.}
}
\description{
Animate an actionButton and it's icon using
\href{https://github.com/IanLunn/Hover}{Hover.css}
}
\examples{
if (interactive()) {
  library(shiny)
  library(hover)

  ui <- fluidPage(
    use_hover(),
    hover_action_button(
      inputId = "btn",
      label = "hello hover!",
      icon = icon("refresh"),
      button_animation = "rotate",
      icon_animation = "spin"
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
