% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_exposure.R
\name{map_counties}
\alias{map_counties}
\title{Map counties}
\usage{
map_counties(
  storm,
  metric = "distance",
  wind_var = "vmax_sust",
  days_included = c(-2, -1, 0, 1),
  add_track = TRUE,
  wind_source = "modeled"
)
}
\arguments{
\item{storm}{Character string giving the name of the storm to plot (e.g.,
"Floyd-1999")}

\item{metric}{Character string giving the metric to plot. Current options are
\code{"distance"}, \code{"wind"}, and \code{"rainfall"}. These options are used
to customize the color palette and scale of the choropleth map produced
by this function.}

\item{wind_var}{A character string giving the wind variable to use. Choices
are \code{"vmax_sust"} (maximum sustained winds; default), \code{"vmax_gust"}
(maximum gust winds), \code{"sust_dur"} (minutes of sustained winds of 20 m / s
or higher) and \code{"gust_dur"} (minutes of gust winds of 20 m / s or higher).
If the Extended Best Tracks wind radii are used as the source of wind data,
the \code{"gust_dur"} option cannot be selected.}

\item{days_included}{A numeric vector listing the days to include when
calculating total precipitation. Negative numbers are days before the
closest date of the storm to a county. For example,
\code{c(-1, 0, 1)} would calculate rain for a county as the sum of the
rainfall for the day before, the day of, and the day after the date when
the storm center was closest to the county center. Values can range from
-5 to 3 (i.e., at most, you can calculate the total rainfall from five days
to three days after the day when the storm is closest to the
county).}

\item{add_track}{TRUE / FALSE of whether to add the storm's track to the map. The
default is TRUE.}

\item{wind_source}{A character string specifying the source to use for the winds. Options
are \code{"modeled"}, for estimates based on running a wind model from Best
Tracks data inputs, and \code{"ext_tracks"}, for estimates based on
the wind radii in the Extended Best Tracks data. See the help files for the
datasets \code{storm_winds} and \code{ext_tracks_wind} in the
\code{hurricaneexposuredata} package for more details on each of these sources
for wind estimates. For the gust wind estimates, these are based on applying
a gust factor of 1.49 to the sustained wind estimates in both wind data sources.}
}
\value{
This function creates a choropleth map of counties in the eastern
   part of the United States, showing distance from a storm track, maximum
   wind speed (or duration of winds at or above 20 m / s), or total
   rainfall over a given window of one or more days near the date of the storm's
   closest approach.
}
\description{
Map counties
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

map_counties("Floyd-1999", metric = "rainfall", days_included = c(-2, -1, 0, 1))

map_counties("Katrina-2005", metric = "wind")
map_counties("Katrina-2005", metric = "wind", wind_var = "vmax_gust")
map_counties("Katrina-2005", metric = "wind", wind_var = "sust_dur")
map_counties("Katrina-2005", metric = "wind", wind_source = "ext_tracks")

#' map_counties("Michael-2018", metric = "wind")
map_counties("Michael-2018", metric = "wind", wind_var = "vmax_gust")
map_counties("Michael-2018", metric = "wind", wind_source = "ext_tracks")
}
}
