#' @title Zachary's karate club network data
#'
#' @description The social network of a university karate club described in the paper "An Information Flow Model for Conflict and Fission in Small Groups" by Wayne W. Zachary.
#'
#' Edges indicate social interactions between members
#'
#' @format A list with the elements:
#' \describe{
#' \item{adjacency}{The adjacency matrix of the karate club network}
#' \item{distances}{The shortest-path distance between nodes}
#' \item{labels}{Node labels. 'A' and 'H' are John A. and Mr. Hi, who led the two groups after the split of the club}
#' \item{group}{The two groups after the split}
#' }
#'
#' @docType data
#' @name karate
#' @usage data(karate)
NULL
