% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iCARH.parameters.R
\name{iCARH.getBeta}
\alias{iCARH.getBeta}
\alias{iCARH.getARCoeff}
\alias{iCARH.getTreatmentEffect}
\alias{iCARH.getPathwaysCoeff}
\alias{iCARH.getDataImputation}
\title{Return model parameters}
\usage{
iCARH.getBeta(fit)

iCARH.getARCoeff(fit)

iCARH.getTreatmentEffect(fit)

iCARH.getPathwaysCoeff(fit, path.names = NULL)

iCARH.getDataImputation(fit)
}
\arguments{
\item{fit}{Object returned by iCARH.model}

\item{path.names}{pathway names}
}
\value{
the \code{iCARH.get[*]} functions return a an array with corresponding model parameters MCMC draws.
}
\description{
Group of functions to return model parameters of interest
}
\section{Functions}{
\itemize{
\item \code{iCARH.getBeta}: Get beta parameter draws from all chains combined

\item \code{iCARH.getARCoeff}: return theta coefficients

\item \code{iCARH.getTreatmentEffect}: return alpha coefficients

\item \code{iCARH.getPathwaysCoeff}: return phi coefficients

\item \code{iCARH.getDataImputation}: return complete data (including imputed data)
}}

\examples{
data.sim = iCARH.simulate(4, 10, 14, 8, 2, path.probs=0.3, Zgroupeff=c(0,4),
beta.val=c(1,-1,0.5, -0.5))
XX = data.sim$XX
Y = data.sim$Y
Z = data.sim$Z
pathways = data.sim$pathways
\donttest{
rstan_options(auto_write = TRUE)
options(mc.cores = 2)
fit = iCARH.model(XX, Y, Z,groups=rep(c(0,1), each=5), pathways, 
control = list(adapt_delta = 0.99, max_treedepth=10), iter = 2, chains = 2)
if(!is.null(fit$icarh))
iCARH.getBeta(fit)}

}
