% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gsea_path.R
\name{get_gsea_path}
\alias{get_gsea_path}
\title{Gene Set Enrichment Analysis (GSEA) using Multiplex Networks}
\usage{
get_gsea_path(
  seed = seed,
  network = network,
  gamma = 0.7,
  pathlist = pathlist,
  gsea.weight = 1,
  gsea.nperm = 1000
)
}
\arguments{
\item{seed}{A seed value (optional).}

\item{network}{A network object (e.g., protein-protein interaction network).}

\item{gamma}{A parameter for random walk restart (default: 0.7).}

\item{pathlist}{A predefined list of gene sets (pathways).}

\item{gsea.weight}{Weight for GSEA (default: 1).}

\item{gsea.nperm}{Number of permutations for significance testing (default: 1000).}
}
\value{
A GSEA result object.
}
\description{
This function performs gene set enrichment analysis (GSEA) based on multiplex network data.
}
\details{
The function constructs a multiplex network, performs random walk restart, and calculates gene scores.
It then transforms the scores and applies GSEA using the provided gene sets.
}
\examples{
data(Seeds, package = "iPRISM")
data(ppi, package = "iPRISM")
data(path_list, package = "iPRISM")

\donttest{
result <- get_gsea_path(seed = Seeds,
                       network = ppi,
                       pathlist = path_list[1:2],
                       gsea.nperm = 100)
print(result)
}

}
\keyword{analysis}
\keyword{enrichment}
\keyword{gene}
\keyword{multiplex}
\keyword{network}
\keyword{pathway}
\keyword{set}
