% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.lrt.r
\name{model.lrt}
\alias{model.lrt}
\title{likelihood ratio test for two models}
\usage{
model.lrt(d1, d2, parallel = FALSE)
}
\arguments{
\item{d1}{An object of class 'dis.kstest'.}

\item{d2}{An object of class 'dis.kstest'.}

\item{parallel}{Whether to use multiple threads to parallelize computation. Default is FALSE. Please aware that it may take
longer time to execute the program with \code{parallel=FALSE}.}
}
\value{
The p-value of the likelihood ratio test.
}
\description{
Conduct likelihood ratio test for comparing two different models.
}
\details{
If the \code{pvalue} of \code{d1} and \code{d2} are greater than the user-specified significance level, which indicates that
the original data \code{x} may come from the two distributions in \code{d1} and \code{d2}, a likelihood ratio test is
desired to choose a more 'possible' distribution based on the current data. NOTE that the \code{x} in \code{d1} and \code{d2}
must be IDENTICAL! Besides, NOTE that the \code{distri} in \code{d1} and \code{d2} must be DIFFERENT!

The \code{distri} inherited from \code{d1} is the null distribution and that from \code{d2} is used as the alternative
distribution. Following Aldirawi et al. (2019), \code{nsim} bootstrapped or simulated samples will be generated according to
\code{bootstrap} of \code{d1}, based on which \code{nsim} maximum likelihood estimates of the parameters in null distribution
will be calculated. Remember that we have obtained \code{nsim} such maximum likelihood estimates while calling function
\code{dis.kstest}. Thus, the algorithm just adopts the \code{mle_new} from \code{d1} to avoid repetitive work. Using the
\code{nsim} maximum likelihood estimates to generate \code{nsim} new samples and calculate \code{nsim} corresponding new
likelihood ratio test statistics. The output p-value is the proportion of new samples that have statistics greater than the
test statistic of the original data \code{x}.

As in \code{\link{dis.kstest}}, the computation is parallelized with the help of packages \code{foreach} and
\code{doParallel}.

With the output p-value smaller than the user-specified significance level, the \code{distri} of \code{d2} is more appropriate
for modelling \code{x}. Otherwise, There is no significant difference between \code{distri} of \code{d1} and \code{distri} of \code{d2},
given the current data.
}
\section{Reference}{

\itemize{
 \item{H. Aldirawi, J. Yang, A. A. Metwally (2019). Identifying Appropriate Probabilistic Models for Sparse Discrete Omics Data,
 accepted for publication in 2019 IEEE EMBS International Conference on Biomedical & Health Informatics (BHI).}
 \item{T. Wolodzko (2019). extraDistr: Additional Univariate and Multivariate Distributions, R package version 1.8.11,
  https://CRAN.R-project.org/package=extraDistr.}
 \item{R. Calaway, Microsoft Corporation, S. Weston, D. Tenenbaum (2017). doParallel: Foreach Parallel Adaptor for the 'parallel'
 Package, R package version 1.0.11, https://CRAN.R-project.org/package=doParallel.}
 \item{R. Calaway, Microsoft, S. Weston (2017). foreach: Provides Foreach Looping Construct for R, R package version 1.4.4,
  https://CRAN.R-project.org/package=foreach.}
}
}

\examples{
set.seed(2001)
temp1=sample.zi(N=300,phi=0.3,distri='poisson',lambda=5)
d1=dis.kstest(temp1,nsim=100,bootstrap=TRUE,distri='zip')
d2=dis.kstest(temp1,nsim=100,bootstrap=TRUE,distri='zinb')
model.lrt(d1,d2)
}
\seealso{
\code{\link{dis.kstest}}
}
