% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingFunctions.R
\name{lines.icenReg_fit}
\alias{lines.icenReg_fit}
\title{Plotting for icenReg Fits}
\usage{
\method{lines}{icenReg_fit}(
  x,
  y,
  newdata = NULL,
  fun = "surv",
  cis = F,
  ci_level = 0.9,
  survRange = c(0.025, 1),
  evalPoints = 20,
  ...
)
}
\arguments{
\item{x}{icenReg fit}

\item{y}{new data.frame}

\item{newdata}{new data.frame (ignored if \code{y} is included)}

\item{fun}{Function to be plotted. Options include \code{"surv"} or \code{"cdf"}}

\item{cis}{Should confidence/credible interval be plotted?}

\item{ci_level}{Confidence/credible interval}

\item{survRange}{Range of survival curve to be plotted}

\item{evalPoints}{Number of evaluations of survival curve to be plotted.}

\item{...}{additional arguments to be passed to the base \code{plot} function}
}
\description{
Plotting for icenReg Fits
}
\details{
Plots survival function from either an \code{ic_np, ic_sp, ic_par} or \code{ic_bayes}
object. If \code{newdata} is \code{NULL}, the baseline distribution is plotted. Otherwise,
 \code{newdata} should be a \code{data.frame} with each row containing a set 
 covariates for which the fit will be plotted. If multiple rows are included, 
 the lines will be colored and a legend will be created using the rownames of \code{newdata}.
 
 For \code{ic_np} and \code{ic_sp}, the MLE is plotted with no intervals (at the time
 of writing this, there is no formula for standard errors of baseline distributions 
 for these methods). 

 For \code{ic_par} and \code{ic_bayes}, the output plotted is directly extracted from
 \code{survCIs}.
 
 If the argument \code{col} is provided, it will be used to color each 
 survival function in order of the rows provided in \code{newdata}.
}
\examples{
 # Fitting mice data set
 data(miceData)
 miceFit <- ic_par(cbind(l, u) ~ grp, data = miceData) 
 
 # Creating covariates we want plotted
 newData <- data.frame(grp = c("ce", "ge"))
 # Naming rows for legend
 rownames(newData) <- c("Conventional", "Germ-Free")
 
 plot(miceFit, newdata = newData, 
      col = c('blue', 'orange'))
}
