% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_UMLE.R
\name{ic_LCM_UMLE}
\alias{ic_LCM_UMLE}
\title{Compute Least Concave Majorant (LCM) of the log of the Unconstrained MLE for Interval-Censored Data}
\usage{
ic_LCM_UMLE(X)
}
\arguments{
\item{X}{A matrix with two columns, where each row represents an interval (L, R] for interval-censored data.
\code{L} and \code{R} are the left and right endpoints, respectively, with \code{R = Inf} indicating right-censoring.}
}
\value{
A list containing:
\item{est}{A list with \code{tau_no_Inf} (finite values of \code{tau}), \code{phi_hat} (LCM of log of \code{F_hat}), 
          and \code{F_hat} (exp of \code{phi_hat}).}
\item{knot_info}{A list with \code{knot_index} (indices of knots in \code{tau_no_Inf}), 
                 \code{tau_on_knot} (values of \code{tau} at knots), 
                \code{F_on_knot} (\code{F_hat} at knots), 
                and \code{phi_on_knot} (\code{phi_hat} at knots).}
\item{neg_log_likelihood}{The negative log-likelihood of the LCM fit.}
\item{weight}{Vector of weights corresponding to each interval in the data.}
\item{X}{The original interval-censored data matrix input.}
}
\description{
This function computes the Least Concave Majorant (LCM) of the log of the unconstrained MLE for interval-censored data.
}
\examples{
data(lgnm)
result <- ic_LCM_UMLE(X = lgnm)
}
