% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_LCMLE.R
\name{icm_subset_cpp}
\alias{icm_subset_cpp}
\title{Iterative Convex Minorant (ICM) Subset Algorithm}
\usage{
icm_subset_cpp(
  phi_tilde_initial,
  is,
  tau_no_Inf,
  L_Rc,
  Lc_R,
  Lc_Rc,
  ri,
  li,
  weight,
  tol = 1e-10,
  max_iter = 500
)
}
\arguments{
\item{phi_tilde_initial}{A numeric vector representing the initial values of the reduced variables \code{phi_tilde}.}

\item{is}{A numeric vector indicating the nodes with unequal left-hand slope and right-hand slope.}

\item{tau_no_Inf}{A numeric vector containing the unique time points, excluding infinity.}

\item{L_Rc}{Indices of observations where the event is in the intersection of L group and the complement of R group. 
The L group consists of samples with left intervals time <= min(all right intervals time). 
The R group consists of samples with infinity right interval time.}

\item{Lc_R}{Indices of observations where the event is in the intersection of the complement of L group and R group.}

\item{Lc_Rc}{Indices of observations where the event is in the intersection of the complement of L group and the complement of R group.}

\item{ri}{A numeric vector of indices corresponding to the right bounds of the intervals in \code{tau_no_Inf}.}

\item{li}{A numeric vector of indices corresponding to the left bounds of the intervals in \code{tau_no_Inf}.}

\item{weight}{A numeric vector representing the weights for each observation.}

\item{tol}{A numeric value specifying the tolerance for convergence. Default is \code{1e-10}.}

\item{max_iter}{An integer specifying the maximum number of iterations. Default is \code{500}.}
}
\value{
A list containing:
\describe{
  \item{phi_tilde_hat}{The estimated values of the reduced variable \code{phi_tilde} at the end of the ICM iterations.}
}
}
\description{
This function implements the ICM algorithm for solving the sub-problem in the active set algorithm.
This is a support of the active set algorithm, computing the optimal values \code{phi_tilde} with reduced number of knots in the sub-problem.
It uses backtracking to ensure convergence (Jongbloed, 1998).
}
\references{
Jongbloed, G.: The iterative convex minorant algorithm for nonparametric estimation. J. Comput. Gr. Stat. 7(3), 310–321 (1998)
}
