% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_functions.R
\name{neg_log_like}
\alias{neg_log_like}
\title{Compute the Negative Log-Likelihood for the Interval-Censored Model}
\usage{
neg_log_like(x, weight, li, ri, L_Rc, Lc_R, Lc_Rc, type = "", tau_no_Inf)
}
\arguments{
\item{x}{A numeric vector of parameter estimates (can be in terms of \code{phi}, or \code{F}).}

\item{weight}{A numeric vector of weights for the observations.}

\item{li}{A numeric vector of indices corresponding to the left bounds of the intervals in \code{tau_no_Inf}.}

\item{ri}{A numeric vector of indices corresponding to the right bounds of the intervals in \code{tau_no_Inf}.}

\item{L_Rc}{Indices of observations where the event is in the intersection of L group and the complement of R group. 
The L group consists of samples with left intervals time <= min(all right intervals time). 
The R group consists of samples with infinity right interval time.}

\item{Lc_R}{Indices of observations where the event is in the intersection of the complement of L group and R group.}

\item{Lc_Rc}{Indices of observations where the event is in the intersection of the complement of L group and the complement of R group.}

\item{type}{A character string indicating the parameterization of \code{x}. Options are \code{"phi"} (log of F), or \code{"F"}.}

\item{tau_no_Inf}{A numeric vector of unique time points excluding infinity.}
}
\value{
The negative log-likelihood value.
}
\description{
This function computes the negative log-likelihood of an interval-censored model based on the specified parameterization.
}
