% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_visualization.R
\name{plot.iclogcondist}
\alias{plot.iclogcondist}
\title{Plot Method for iclogcondist_plot Objects}
\usage{
\method{plot}{iclogcondist}(x, log = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{iclogcondist}, typically generated by \code{ic_UMLE}, \code{ic_LCM_UMLE}, or \code{ic_LCMLE}.}

\item{log}{Logical; if \code{TRUE}, plots the log cumulative distribution function \code{logF(t)}. 
If \code{FALSE}, plots \code{F(t)}. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to the plotting function.}
}
\value{
An invisible \code{ggplot} object representing the plot. The plot is also displayed in the current graphics device.
}
\description{
This function generates a plot for objects of class \code{iclogcondist}, which are typically generated by 
\code{ic_UMLE}, \code{ic_LCM_UMLE}, or \code{ic_LCMLE}. The plot can display either the cumulative 
distribution function \code{F(t)} or the log cumulative distribution function \code{logF(t)}, depending on the 
setting of the \code{log} parameter.
}
\examples{
# Example usage with ic_UMLE, ic_LCM_UMLE, and ic_LCMLE
data(lgnm)
X <- lgnm
fit_UMLE <- ic_UMLE(X)
fit_LCM_UMLE <- ic_LCM_UMLE(X)
fit_LCMLE <- ic_LCMLE(X)
plot(fit_UMLE, log = TRUE)   # Plot logF(t) for UMLE
plot(fit_LCM_UMLE, log = FALSE)  # Plot F(t) for LCM_UMLE
plot(fit_LCMLE, log = FALSE) # Plot F(t) for LCMLE
}
