% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pick_best_cluster_simon}
\alias{pick_best_cluster_simon}
\title{Select the Best Clustering Based on Weighted Scores: AUROC, Modularity, and Silhouette}
\usage{
pick_best_cluster_simon(dataset, tsne_clust, tsne_calc, settings)
}
\arguments{
\item{dataset}{A data frame representing the original dataset, where each observation will be assigned cluster labels
from each clustering configuration in \code{tsne_clust}.}

\item{tsne_clust}{A list of clustering results from different t-SNE configurations, with each element containing
\code{pandora_cluster} assignments and clustering information.}

\item{tsne_calc}{An object containing t-SNE results on \code{dataset}.}

\item{settings}{A list of settings for machine learning model training and scoring, including:
\describe{
\item{excludedColumns}{A character vector of columns to exclude from the analysis.}
\item{preProcessDataset}{A character vector of preprocessing steps (e.g., scaling, centering).}
\item{selectedPartitionSplit}{Numeric; the partition split ratio for train/test splits.}
\item{selectedPackages}{Character vector of machine learning models to train.}
\item{trainingTimeout}{Numeric; time limit (in seconds) for training each model.}
\item{weights}{A list of weights for scoring criteria: \code{weights$AUROC}, \code{weights$modularity},
and \code{weights$silhouette} (default is 0.4, 0.3, and 0.3 respectively).}
}}
}
\value{
A list containing the best clustering configuration (with the highest weighted score) and its associated information.
}
\description{
This function selects the optimal clustering configuration from a list of \code{t-SNE} clustering results
by evaluating each configuration's AUROC, modularity, and silhouette scores. These scores are combined
using a weighted average, allowing for a more comprehensive assessment of each configuration's relevance.
}
\details{
For each clustering configuration in \code{tsne_clust}, this function:
\enumerate{
\item Assigns cluster labels to the dataset.
\item Trains machine learning models specified in \code{settings} on the dataset with cluster labels.
\item Evaluates each model based on AUROC, modularity, and silhouette scores.
\item Selects the clustering configuration with the highest weighted average score as the best clustering result.
}
}
\keyword{internal}
