% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation_funs.R
\name{get_p_infection_year}
\alias{get_p_infection_year}
\title{Calculate the probability imprinting occurs n years after birth}
\usage{
get_p_infection_year(
  birth_year,
  observation_year,
  intensity_df,
  max_year,
  baseline_annual_p_infection = 0.28
)
}
\arguments{
\item{birth_year}{year of birth (numeric). Must be between 1918 and the current calendar year.}

\item{observation_year}{year of observation, which affects the birth cohort's age.}

\item{intensity_df}{data frame of annual intensities, output by \code{\link[=get_country_intensity_data]{get_country_intensity_data()}}.}

\item{max_year}{maximum year for which to output probabilities. Must be greater than or equal to observation_year. (If in doubt, set equal to observation year.)}

\item{baseline_annual_p_infection}{average annual probability of primary infection. The default, 0.28, was estimated using age-seroprevalence data in \doi{https://doi.org/10.1126/science.aag1322}{Gostic et al. Science, (2016)}.}
}
\value{
a vector whose entries show the probability that a person born
in year 0 was first infected by influenza in year 0, 1, 2, 3, ...12
We only consider the first 13 probabilities (i.e. we assume everyone
imprints before age 13. These outputs are not normalized, so the
vector sum asymptotically approaches one, but is not exactly equal
to one. For cohorts born <13 years prior to the year of observation,
the output vector will have less than 13 entries.
}
\description{
Given an individual's birth year, the year of observation, and pre-calculated influenza circulation intensities, calculate the probability that the first influenza infection occurs exactly 0, 1, 2, ... 12 years after birth.
}
\details{
The probability of primary influenza infection n years after birth is calculated based on a modified \href{https://en.wikipedia.org/wiki/Geometric_distribution}{geometric distribution}: let p be the average annual probability of a primary influenza infection. Then the probability that primary infection occurs n=0,1,2,... years after birth is \eqn{p*(1-p)^{n}}.

This function modifies the geometric model above to account for changes in annual circulation intensity, so that annual probabilities of primary infection \eqn{p_i} are scaled by the intensity in calendar year i. Details are given in \doi{https://doi.org/10.1126/science.aag1322}{Gostic et al. Science, (2016)}.
}
\examples{
# For a cohort under 12 years old and born in 2000, return the
# probabilities of primary infection in 2000, 2001, ... 2012:
get_p_infection_year(
  birth_year = 2000,
  observation_year = 2022,
  intensity_df = get_country_intensity_data("Canada", 2022),
  max_year = 2022
)

# If the cohort is still under age 12 at the time of observation, return
# a truncated vector of probabilities:
get_p_infection_year(
  birth_year = 2020,
  observation_year = 2022,
  intensity_df = get_country_intensity_data("Mexico", 2022),
  max_year = 2022
)

}
