% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imptree.R
\name{imptree}
\alias{imptree}
\alias{imptree.formula}
\alias{imptree.default}
\title{Classification Trees with Imprecise Probabilities}
\usage{
\method{imptree}{formula}(formula, data = NULL, weights, control,
  method = c("IDM", "NPI", "NPIapprox"), method.param, ...)

\method{imptree}{default}(x, y, ...)

imptree(x, ...)
}
\arguments{
\item{formula}{Formula describing the strucutre
(class variable ~ featutre variables).
Any interaction terms trigger an error.}

\item{data}{Data.frame to evaluate supplied formula on.
If not provided the the formula is evaluated 
on the calling environment}

\item{weights}{Individual weight of the observations
(default: 1 to each).
\emph{This argument is ignored at the moment.}}

\item{control}{A named (partial) list according to the result of
\code{\link{imptree_control}}.}

\item{method}{Method applied for calculating the probability
intervals of the class probability. \code{"IDM"} for the imprecise
Dirichlet model (default), \code{"NPI"} for use of the 
nonparametric predictive inference approach and \code{"NPIapprox"}
for use of the approximate algorithm obtaining maximal entropy of
NPI generated probability intervals.}

\item{method.param}{Named list providing the method specific 
parameters. See \code{\link{imptree_params}}.}

\item{\dots}{optional parameters to be passed to the main function
\code{imptree.formula} or to the call of
\code{\link{imptree_control}}.}

\item{x}{A data.frame or a matrix of feature variables.
The columns are required to be named.}

\item{y}{The classification variable as a factor.}
}
\value{
An object of class \code{imptree}, which is a list
with the following components:
\item{call}{Original call to \code{imptree}}
\item{tree}{Object reference to the underlying C++ tree object.}
\item{train}{Training data in the form required by the 
workhorse C++ function.\cr
It is an integer matrix containing the internal factor
representations, adjusted for the C++ specific indexing
starting at 0 and not at 1 as in R.
Further attributes of the matrix, hold the names of the variables,
the C++ adjusted index of the classification variabe, as well as
the levels and number of levels for each variable.}
\item{formula}{The formula describing the data structure}
}
\description{
\code{imptree} implements Abellan and Moral's tree 
algorithm (based on Quinlans ID3) for classification. It
employes either the imprecise Dirichlet model (IDM) or
nonparametric predictive inference (NPI) to generate the
imprecise probability distribution of the classification variable
within a node.
}
\examples{
data("carEvaluation")

## create a tree with IDM (s=1) to full size on
## carEvaluation, leaving the first 10 observations out
imptree(acceptance~., data = carEvaluation[-(1:10),], 
  method="IDM", method.param = list(splitmetric = "globalmax", s = 1), 
  control = list(depth = NULL, minbucket = 1)) # control args as list

## same setting as above, now passing control args in '...'
imptree(acceptance~., data = carEvaluation[-(1:10),], 
  method="IDM", method.param = list(splitmetric = "globalmax", s = 1), 
  depth = NULL, minbucket = 1)

}
\references{
Abell\ifelse{latex}{\out{\'{a}}}{\ifelse{html}{\out{&aacute;}}{a}}n,
J. and Moral, S. (2005), Upper entropy of credal sets. Applications to 
credal classification, \emph{International Journal of Approximate Reasoning}
\bold{39}, 235--255.

Strobl, C. (2005), Variable Selection in Classification Trees Based on
Imprecise Probabilities, \emph{ISIPTA'05: Proceedings of the Fourth
International Symposium on Imprecise Probabilities and Their Applications},
339--348.

Baker, R. M. (2010), \emph{Multinomial Nonparametric Predictive Inference:
Selection, Classification and Subcategory Data}.
}
\seealso{
\code{\link{predict.imptree}} for prediction,
\code{\link{summary.imptree}} for summary information, 
\code{\link{imptree_params}} and \code{\link{imptree_control}} for
arguments controlling the creation, \code{\link{node_imptree}} for
accessing a specific node in the tree
}
\author{
Paul Fink \email{Paul.Fink@stat.uni-muenchen.de},
based on algorithms by 
J. Abell\ifelse{latex}{\out{\'{a}}}{\ifelse{html}{\out{&aacute;}}{a}}n
and S. Moral for the IDM and R. M. Baker for the NPI approach.
}
\keyword{tree}
