% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_heavy_REE.r
\name{correct_heavy}
\alias{correct_heavy}
\title{Corrects for the model deviations of Er, Yb, Lu and Y}
\usage{
correct_heavy(
  dat,
  Y_correction_fact = 1/0.72,
  Ho_correction_fact = 1,
  Er_correction_fact = 1/0.974,
  Tm_correction_fact = 1,
  Yb_correction_fact = 1/0.907,
  Lu_correction_fact = 1/0.926
)
}
\arguments{
\item{dat}{A dataframe}

\item{Y_correction_fact}{a number: correction factor for underestimated Y. 1/ 0.72 by default.}

\item{Ho_correction_fact}{a number: correction factor for Ho. 1 by default.}

\item{Er_correction_fact}{a number: correction factor for underestimated Er. 1/0.974 by default.}

\item{Tm_correction_fact}{a number: correction factor for Tm. 1 by default.}

\item{Yb_correction_fact}{a number: correction factor for underestimated Yb. 1/0.907  by default.}

\item{Lu_correction_fact}{a number: correction factor for underestimated Lu. 1/0.926 by default.}
}
\value{
a data frame
}
\description{
Calculated value of Yb, Lu and Y slightly deviates from the linear regression. This function apply a correction to compensates those deviations. This function is wrapped inside model_REE()
}
