% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blm.R
\docType{class}
\name{blm}
\alias{blm}
\title{Bayesian Linear Model Factory}
\description{
Bayesian Linear Model Factory

Bayesian Linear Model Factory
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{version}}{im package version used to fit model}

\item{\code{eta_draws}}{Posterior draws for the treatment effect}

\item{\code{mcmChecks}}{MCMC diagnostics}

\item{\code{credible_interval}}{Credible interval for the treatment effect}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-blm-new}{\code{blm$new()}}
\item \href{#method-blm-ppcDensOverlay}{\code{blm$ppcDensOverlay()}}
\item \href{#method-blm-tracePlot}{\code{blm$tracePlot()}}
\item \href{#method-blm-posteriorProb}{\code{blm$posteriorProb()}}
\item \href{#method-blm-pointEstimate}{\code{blm$pointEstimate()}}
\item \href{#method-blm-credibleInterval}{\code{blm$credibleInterval()}}
\item \href{#method-blm-priorProb}{\code{blm$priorProb()}}
\item \href{#method-blm-priorInterval}{\code{blm$priorInterval()}}
\item \href{#method-blm-vizdraws}{\code{blm$vizdraws()}}
\item \href{#method-blm-clone}{\code{blm$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-new"></a>}}
\if{latex}{\out{\hypertarget{method-blm-new}{}}}
\subsection{Method \code{new()}}{
Get the package version


Get the posterior draws for eta


Get the MCMC diagnostics


Get the credible interval


Create a new Bayesian Linear Model object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$new(
  data,
  y,
  x,
  treatment,
  eta_mean,
  eta_sd,
  generate_fake_data = 0,
  seed = 1982,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Data frame to be used}

\item{\code{y}}{Name of the outcome variable in the data frame}

\item{\code{x}}{Vector of names of all covariates in the data frame}

\item{\code{treatment}}{Name of the treatment indicator variable in the data frame}

\item{\code{eta_mean}}{Prior mean for the treatment effect estimation}

\item{\code{eta_sd}}{Prior standard deviation for the treatment effect estimation}

\item{\code{generate_fake_data}}{Flag for generating fake data}

\item{\code{seed}}{Seed for Stan fitting}

\item{\code{...}}{Additional arguments for Stan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-ppcDensOverlay"></a>}}
\if{latex}{\out{\hypertarget{method-blm-ppcDensOverlay}{}}}
\subsection{Method \code{ppcDensOverlay()}}{
This method compares the empirical distribution of the data 'y'
to the distributions of simulated/replicated data 'yrep' from the
posterior predictive distribution. This is done by creating a density
overlay plot using the \code{bayesplot::ppc_dens_overlay} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$ppcDensOverlay(n = 50)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of posterior draws to use for the overlay}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 visualization
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-tracePlot"></a>}}
\if{latex}{\out{\hypertarget{method-blm-tracePlot}{}}}
\subsection{Method \code{tracePlot()}}{
Plot MCMC trace for the eta and sigma parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$tracePlot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments for Stan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-posteriorProb"></a>}}
\if{latex}{\out{\hypertarget{method-blm-posteriorProb}{}}}
\subsection{Method \code{posteriorProb()}}{
Calculate posterior probability of effect exceeding a threshold

This function calculates the posterior probability of the effect
being larger or smaller than a specified threshold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$posteriorProb(threshold = 0, gt = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{A numeric value specifying the threshold.}

\item{\code{gt}}{A logical value indicating whether to calculate the probability
of the effect being greater than (TRUE) or less than (FALSE)
the threshold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function uses the private$..eta_draws internal variable
to obtain draws from the posterior distribution of the effect size.
Based on the specified arguments, the function calculates the
proportion of draws exceeding/falling below the threshold and
returns a formatted statement describing the estimated probability.

Calculate point estimate of the effect

This R6 method calculates the point estimate of the effect size
based on the posterior draws of the eta parameter.
}

\subsection{Returns}{
A character string summarizing the estimated probability.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-pointEstimate"></a>}}
\if{latex}{\out{\hypertarget{method-blm-pointEstimate}{}}}
\subsection{Method \code{pointEstimate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$pointEstimate(median = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{median}}{Logical value. If TRUE (default), the median of
the eta draws is returned. If FALSE, the mean is returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the private$..eta_draws internal variable
which contains MCMC draws of the eta parameter representing the
effect size. Based on the specified median argument, the method
calculates and returns either the median or the mean of the draws.
Calculates credible interval for the effect of the intervention

This R6 method calculates and returns a formatted statement summarizing
the credible interval of a specified width for the effect of the intervention.
}

\subsection{Returns}{
A numeric value representing the point estimate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-credibleInterval"></a>}}
\if{latex}{\out{\hypertarget{method-blm-credibleInterval}{}}}
\subsection{Method \code{credibleInterval()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$credibleInterval(width = 0.75, round = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Numeric value between 0 and 1 representing the desired
width of the credible interval (e.g., 0.95 for a 95\% credible interval).}

\item{\code{round}}{Integer value indicating the number of decimal places to round
the lower and upper bounds of the credible interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the private$..eta_draws internal variable
containing MCMC draws of the eta parameter representing the effect
size. It calculates the credible interval, stores it internally, and
returns a formatted statement summarizing the findings.

Calculate and format probability statement based on prior

This method calculates the probability that the effect is greater than or
less than a given threshold based on the prior distribution of the effect.
The results are formatted into a statement suitable for reporting.
}

\subsection{Returns}{
A character string with the following information:
\itemize{
\item The probability associated with the specified width
\item The lower and upper bounds of the credible interval, rounded to the
specified number of decimal places
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-priorProb"></a>}}
\if{latex}{\out{\hypertarget{method-blm-priorProb}{}}}
\subsection{Method \code{priorProb()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$priorProb(threshold = 0, gt = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{Numerical threshold for comparison.}

\item{\code{gt}}{Logical indicating whether to calculate probability greater than
or less than the threshold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string containing the formatted probability statement.
Calculates the prior for the effedt of the intervention based on
the hyperpriors.

This method computes and formats a statement about the probability interval
of the effect based on the prior distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-priorInterval"></a>}}
\if{latex}{\out{\hypertarget{method-blm-priorInterval}{}}}
\subsection{Method \code{priorInterval()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$priorInterval(width = 0.75, round = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Desired probability width of the interval (default: 0.75).}

\item{\code{round}}{Number of decimal places for rounding the bounds (default: 0).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method calculates the lower and upper bounds of the interval based
on the specified probability width and the prior distribution of the effect.
It then formats the results into a clear and informative statement.

Note that the probability is checked to be within valid range (0-1) with
consideration of machine precision using .Machine$double.eps.
}

\subsection{Returns}{
A character string containing the formatted probability interval
statement.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-vizdraws"></a>}}
\if{latex}{\out{\hypertarget{method-blm-vizdraws}{}}}
\subsection{Method \code{vizdraws()}}{
Plots impact's prior and posterior distributions.

For more details see \code{\link[vizdraws:vizdraws]{vizdraws::vizdraws()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$vizdraws(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{other arguments passed to vizdraws.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An interactive plot of the prior and posterior distributions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-blm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-blm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{blm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
