% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{pointEstimate}
\alias{pointEstimate}
\title{Calculate Point Estimate (Median or Mean) as Percentage}
\usage{
pointEstimate(x, median = TRUE)
}
\arguments{
\item{x}{A numeric vector containing the data from which to calculate the point estimate.}

\item{median}{A logical value indicating whether to use the median (default: \code{TRUE})
or the mean (\code{FALSE}) as the point estimate.}
}
\value{
A numeric value representing the chosen point estimate (median or mean)
of the input vector \code{x}, multiplied by 100 to express it as a percentage.
}
\description{
This function computes a point estimate from a numeric vector,
returning either the median or the mean as a percentage.
}
\details{
This function provides a simple way to obtain either the median or mean
of a numeric vector as a percentage. The choice between these two measures
of central tendency can be controlled by the \code{median} argument.
}
