% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid_delay_dist}
\alias{covid_delay_dist}
\title{Delay distribution from COVID-19 pandemic.}
\format{
A data frame with 61 entries and 4 columns.
\describe{
  \item{days}{number of days since infection}
  \item{case}{proportion of cases confirmed by a test that are recorded on that day}
  \item{hospitalization}{proportion of cases that become hospitalized that are hospitalized on that day}
  \item{death}{proportion of cases that result in death that die on that day}
}
}
\source{
Time from incidence to symptoms: Lauer et al., "Estimated Incubation Period of COVID-19", ACC (2020). \url{https://www.acc.org/latest-in-cardiology/journal-scans/2020/05/11/15/18/the-incubation-period-of-coronavirus-disease}.

Time from symptoms to recorded cases: Case line data from Florida through 2020-07-14 with same day waits removed. \url{https://open-fdoh.hub.arcgis.com/datasets/florida-covid19-case-line-data}.

Time from symptoms to hospitalization: Wang et al., "Clinical Characteristics of 138 Hospitalized Patients With 2019 Novel Coronavirus–Infected Pneumonia in Wuhan, China", JAMA (2020). \url{https://jamanetwork.com/journals/jama/fullarticle/2761044}.

Time from hospitalization to death: Lewnard et al. "Incidence, clinical outcomes, and transmission dynamics of severe coronavirus disease 2019 in California and Washington: prospective cohort study", BJM (2020). \url{https://www.bmj.com/content/369/bmj.m1923.long}
}
\usage{
covid_delay_dist
}
\description{
Daily case, hospitalization, and death proportions.
}
\keyword{datasets}
