% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hash_table.R
\name{create_hash_table}
\alias{create_hash_table}
\title{Create a Table of the Parameters for Saved Results from RDS Files}
\usage{
create_hash_table(folder, save_path = NULL, filter_list = NULL)
}
\arguments{
\item{folder}{A string specifying the directory containing the RDS files.}

\item{save_path}{An optional string specifying the path to save the resulting hash table as a CSV file.
If \code{NULL}, the hash table is not saved.}

\item{filter_list}{An optional list of filters to apply to the hash table.
Each element of the list should be named according to a column in the hash table
and contain the value to filter for in that column.}
}
\value{
A data frame where each row corresponds to an \code{parameters_list} from an RDS file,
with an additional column for the hash of each set of arguments.
}
\description{
Reads in all the parameter files for a give folder, flattens nested lists, and then
combines the parameters into a data frame. Each row in the resulting data frame represents
the arguments used for one RDS file, identified by its hash. Optionally, the function can
filter the data frame based on specified criteria and save it to a file.
}
\details{
Saving the hash table can be helpful for the manipulation of parameters (see \code{?update_hash_table})
or for removal of unwanted results (see \code{?cleanup_from_hash_table}).
}
\examples{
## Setup
tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)

## Save objects
obj1 <- rnorm(1000)
obj2 <- data.frame(
  x = runif(100),
  y = "something",
  z = rep(c(TRUE, FALSE), 50)
)
obj3 <- list(obj1, obj2)

params1 <- list(
  distribution = "normal",
  other_params = list(param1 = TRUE, param2 = 1, param3 = NA)
)
params2 <- list(
  distribution = "uniform",
  other_params = list(param1 = FALSE, param2 = 2, param3 = "1", param4 = 4)
)
params3 <- list(
  distribution = "composite",
  other_params = list(param1 = TRUE, param2 = 3, param3 = 1)
)

save_objects(tmp_dir, obj1, params1)
save_objects(tmp_dir, obj2, params2)
save_objects(tmp_dir, obj3, params3)

## Create hash table (and save it)
create_hash_table(tmp_dir, save_path = file.path(tmp_dir, "hash_table.csv"))

## Cleanup
unlink(tmp_dir, recursive = TRUE)
}
