% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rehash.R
\name{rehash}
\alias{rehash}
\title{Rehash RDS Files in a Directory}
\usage{
rehash(
  folder,
  hash_includes_timestamp = FALSE,
  ignore_na = TRUE,
  alphabetical_order = TRUE,
  algo = "xxhash64"
)
}
\arguments{
\item{folder}{A string specifying the directory containing the RDS files to be rehashed.}

\item{hash_includes_timestamp}{Logical; if TRUE, includes timestamps in the hash generation.}

\item{ignore_na}{Logical; if TRUE, NA values are ignored during hash generation.}

\item{alphabetical_order}{Logical; if TRUE, parameters are sorted alphabetically before hash generation.}

\item{algo}{The (potentially new) hash algorithm to use (see \code{?digest})}
}
\value{
The function does not return a value but renames the RDS files in the specified directory based on new hashes.
}
\description{
This function processes all RDS files in a specified directory, generating new hashes
for each file's \code{args_list} and renaming the files accordingly. It's useful when changing
the hash generation algorithm or parameters (if the parameters are manually changed for some reason).
}
\examples{
## Setup
tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)

# Save example objects
obj1 <- rnorm(1000)
obj2 <- data.frame(
  x = runif(100),
  y = "something",
  z = rep(c(TRUE, FALSE), 50)
)
obj3 <- list(obj1, obj2)

params1 <- list(
  distribution = "normal",
  other_params = list(param1 = TRUE, param2 = 1, param3 = NA)
)
params2 <- list(
  distribution = "uniform",
  other_params = list(param1 = FALSE, param2 = 2, param3 = "1", param4 = 4)
)
params3 <- list(
  distribution = "composite",
  other_params = list(param1 = TRUE, param2 = 3, param3 = 1)
)

save_objects(tmp_dir, obj1, params1)
save_objects(tmp_dir, obj2, params2)
save_objects(tmp_dir, obj3, params3)

## See current file names
list.files(tmp_dir)

## Rehash with new algo
rehash(tmp_dir, algo = "xxhash32")

## Observe new file names
list.files(tmp_dir)

## Cleanup
unlink(tmp_dir, recursive = TRUE)
}
