% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_series_eng.R
\name{inegi_series_multiple}
\alias{inegi_series_multiple}
\title{Returns multiple INEGI data series}
\usage{
inegi_series_multiple(series_id, token, names = NULL, geography = "00",
  database = "BIE")
}
\arguments{
\item{series_id}{A vector of indicator ID's. These are obtained via the INEGI API documentation.}

\item{token}{API token supplied by INEGI.}

\item{names}{Optional vector of names to assign to each id. If NULL, a numerical index is assigned.}

\item{geography}{Geography code of INEGI. Defaults to 00 (National)}

\item{database}{Is the id from BIE (Banco de Informacion Economica) or BISE (Banco de Indicadores). Defaults to BIE. To learn more about what database your indicator is stored in, visit INEGI docs.}
}
\value{
data.frame
}
\description{
Returns a data.frame with multiple time series chosen from INEGI webservice. The output will always be a data.frame (not tibble) with compacted metadata. (See \code{inegi_series} to understand as_tt = FALSE and as_compact = TRUE).
}
\note{
Adding the entire INEGI URL as a series is deprecated since v3, due to a change of API specifications in INEGI. INEGI docs can be found at: \url{https://www.inegi.org.mx/servicios/api_indicadores.html}. Coercing biweekly indicators to monthly is also deprecated inside this function. Use tibbletime functions to coerce instead.
}
\examples{
\dontrun{
# General INPC series
token <- "webservice_token"
some_series <- c("216064", "216097")
result <- inegi_series_multiple(some_series, token)
}
}
\author{
Eduardo Flores
}
