% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifr-os-prop-test.R
\name{ifr_os_prop_test}
\alias{ifr_os_prop_test}
\alias{ifr_os_prop_test.default}
\alias{infer_os_prop_test}
\title{One Sample Test of Proportion}
\usage{
ifr_os_prop_test(
  data,
  variable = NULL,
  prob = 0.5,
  phat = 0.5,
  alternative = c("both", "less", "greater", "all")
)

\method{ifr_os_prop_test}{default}(
  data,
  variable = NULL,
  prob = 0.5,
  phat = 0.5,
  alternative = c("both", "less", "greater", "all")
)
}
\arguments{
\item{data}{numeric vector of length 1 or a \code{data.frame} or \code{tibble}}

\item{variable}{factor; column in \code{data}}

\item{prob}{hypothesised proportion}

\item{phat}{observed proportion}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter.}
}
\value{
\code{ifr_os_prop_test} returns an object of class \code{"ifr_os_prop_test"}.
An object of class \code{"ifr_os_prop_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{phat}{proportion of 1's}
\item{p}{assumed probability of success}
\item{z}{z statistic}
\item{sig}{p-value for z statistic}
\item{alt}{alternative hypothesis}
\item{obs}{observed number of 0's and 1's}
\item{exp}{expected number of 0's and 1's}
\item{deviation}{deviation of observed from expected}
\item{std}{standardized resiudals}
}
\description{
\code{ifr_os_prop_test} compares proportion in one group to a
specified population proportion.
}
\section{Deprecated Function}{

\code{infer_os_prop_test()} has been deprecated. Instead use \code{ifr_os_prop_test()}.
}

\examples{
# use as a calculator
ifr_os_prop_test(200, prob = 0.5, phat = 0.3)

# using data set
ifr_os_prop_test(hsb, female, prob = 0.5)

}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{prop.test}} \code{\link[stats]{binom.test}}
}
