% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrtCoef.R
\name{getTrtCoef}
\alias{getTrtCoef}
\title{Get the Treatment Coefficients}
\usage{
getTrtCoef(design.df, trtTerm)
}
\arguments{
\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{trtTerm}{a vector of character containing the labels of the treatment
terms in the model generated by \code{\link{terms}}.}
}
\value{
The numeric vector.
}
\description{
Compute the overall coefficients every treatment term including the
interaction.
}
\examples{

design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt, stringsAsFactors = TRUE )
})

trt.str = "Trt"
  
fT = terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm = attr(fT,"term.labels")
effectsMatrix = attr(fT,"factor") 
		
trt.Coef = getTrtCoef(design1, trtTerm)


}
\author{
Kevin Chang
}
