% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_pipe}
\alias{bm_pipe}
\alias{bru_mapper_pipe}
\alias{ibm_n.bm_pipe}
\alias{ibm_n_output.bm_pipe}
\alias{ibm_values.bm_pipe}
\alias{ibm_jacobian.bm_pipe}
\alias{ibm_eval.bm_pipe}
\alias{ibm_eval2.bm_pipe}
\alias{ibm_simplify.bm_pipe}
\title{Mapper for linking several mappers in sequence}
\usage{
bm_pipe(mappers)

bru_mapper_pipe(...)

\method{ibm_n}{bm_pipe}(mapper, ..., input = NULL, state = NULL)

\method{ibm_n_output}{bm_pipe}(mapper, input, state = NULL, ..., n_state = NULL)

\method{ibm_values}{bm_pipe}(mapper, ...)

\method{ibm_jacobian}{bm_pipe}(mapper, input, state = NULL, ...)

\method{ibm_eval}{bm_pipe}(mapper, input, state = NULL, ...)

\method{ibm_eval2}{bm_pipe}(mapper, input, state = NULL, ...)

\method{ibm_simplify}{bm_pipe}(
  mapper,
  input = NULL,
  state = NULL,
  inla_f = FALSE,
  ...,
  n_state = NULL
)
}
\arguments{
\item{mappers}{A list of \code{bru_mapper} objects}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}

\item{inla_f}{logical; when \code{TRUE} for \code{ibm_n()} and \code{ibm_values()}, the
result must be compatible with the \code{INLA::f(...)} and corresponding
\code{INLA::inla.stack(...)} constructions.  For \verb{ibm_\{eval,jacobian,linear\}},
the \code{input} interpretation may be different.
Implementations do not normally need to do anything different, except
for mappers of the type needed for hidden multicomponent models such
as "bym2", which can be handled by \code{bm_collect}.}
}
\description{
Create a pipe mapper, where \code{mappers} is a list of mappers,
and the evaluated output of each mapper is handed as the state to the next
mapper.
The \code{input} format for the \code{ibm_eval} and \code{ibm_jacobian} methods is
a list of inputs, one for each mapper.
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_simplify(bm_pipe)}: Constructs a simplified \code{pipe} mapper. For fully linear pipes, calls
\code{\link[=ibm_linear]{ibm_linear()}}.
For partially non-linear pipes, replaces each sequence of linear mappers with
a single \code{\link[=bm_taylor]{bm_taylor()}} mapper, while keeping the full list of
original mapper names, allowing the original \code{input} structure to be used
also with the simplified mappers, since the \code{taylor} mappers are not
dependent on inputs.

}}
\examples{
m <- bm_pipe(list(
  scale = bm_scale(),
  shift = bm_shift()
))
ibm_eval2(m, input = list(scale = 2, shift = 1:4), state = 1:4)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
