% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru_input.R
\name{bru_input}
\alias{bru_input}
\alias{bru_input.default}
\alias{bru_input.bru_comp}
\alias{bru_input.bru_model}
\alias{bru_input.bru_comp_list}
\alias{bru_input.bru_obs_list}
\alias{bru_input.bru_input}
\alias{input_eval}
\alias{evaluate_inputs}
\title{Obtain component inputs}
\usage{
bru_input(...)

\method{bru_input}{default}(input, label = NULL, layer = NULL, selector = NULL, ...)

\method{bru_input}{bru_comp}(component, data, ...)

\method{bru_input}{bru_model}(model, lhoods, ...)

\method{bru_input}{bru_comp_list}(components, data, ...)

\method{bru_input}{bru_obs_list}(lhoods, components, ...)

\method{bru_input}{bru_input}(input, data, env = NULL, null.on.fail = FALSE, ...)

input_eval(...)

evaluate_inputs(...)
}
\arguments{
\item{\dots}{Passed on to sub-methods.}

\item{component}{A \link{bru_comp} object.}

\item{data}{A \code{data.frame}, \code{tibble}, \code{sf}, \code{list}, or \verb{Spatial*} object of
covariates and/or point locations.}

\item{lhoods}{A \link{bru_obs_list} object}

\item{components}{A \link{bru_comp_list}.}
}
\value{
\itemize{
\item \code{bru_input(bru_comp)}: A list of mapper input values, formatted
for the full component mapper (of type \link{bm_pipe})
}
}
\description{
Obtain component inputs
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_input(default)}: Create a \code{bru_input} object.

\item \code{bru_input(bru_obs_list)}: Computes the component inputs for included components
for each model likelihood

\item \code{bru_input(bru_input)}: Attempts to evaluate a component input (e.g. \code{main},
\code{group}, \code{replicate}, or \code{weight}), and process the results:
\enumerate{
\item If \code{eval()} failed, return NULL or map everything to 1
(see the \code{null.on.fail} argument). This should normally not
happen, unless the component use logic is incorrect,
(e.g. via \code{used} or \code{include}/\code{exclude})
leading to missing columns for a certain likelihood in a
multi-\code{bru_obs()} model.
\item If we obtain a function, apply the function to the data object
\item If we obtain an object supported by \code{\link[=eval_spatial]{eval_spatial()}}, extract the values
of that data frame at the point locations
\item Else we obtain a vector and return as-is. This happens when input
references a column of the data points, or some other complete expression
}

}}
\section{Functions}{
\itemize{
\item \code{input_eval()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} from \verb{2.12.0.9023}.
Use \code{bru_input()} instead.

\item \code{evaluate_inputs()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} since version
\verb{2.12.0.9023}. Use \code{\link[=bru_input]{bru_input()}} instead. Computes the component inputs for
included components for each observation model.

}}
\section{Simple covariates and the input parameters}{


It is not unusual for a random effect act on a transformation of a covariate.
In other frameworks this would mean that the transformed covariate would have
to be calculated in advance and added to the data frame that is usually
provided via the \code{data} parameter. inlabru provides the option to do this
transformation automatically. For instance, one might be interested in the
effect of a covariate \eqn{x^2}. In inla and other frameworks this would
require to add a column \code{xsquared} to the input data frame and use the
formula

\itemize{\item{\code{formula = y ~ f(xsquared, model = "linear")},}}

In inlabru this can be achieved in several ways of using the \code{main} parameter
(\code{map} in version 2.1.13 and earlier), which does not need to be named.

\itemize{
\item{\code{components = y ~ psi(x^2, model = "linear")}}
\item{\code{components = y ~ psi(main = x^2, model = "linear")}}
\item{\code{components = y ~ psi(mySquareFun(x), model = "linear")},}
\item{\code{components = y ~ psi(myOtherSquareFun, model = "linear")},}

}

In the first example inlabru will interpret the map parameter as an
expression to be evaluated within the data provided. Since \eqn{x} is a known
covariate it will know how to calculate it. The second example is an
expression as well but it uses a function called \code{mySquareFun}. This function
is defined by user but has to be accessible within the work space when
setting up the components. The third example provides the function
\code{myOtherSquareFun}. In this case, inlabru will call the function as
\code{myOtherSquareFun(.data.)}, where \code{.data.} is the data provided via the
\code{\link[=bru_obs]{bru_obs()}} \code{data} parameter. The function needs to know what parts of the
data to use to construct the needed output. For example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{myOtherSquareFun <- function(data) \{
  data[ ,"x"]^2
\}
}\if{html}{\out{</div>}}
}

\section{Spatial Covariates}{


When fitting spatial models it is common to work with covariates that depend
on space, e.g. sea surface temperature or elevation. Although it is
straightforward to add this data to the input data frame or write a covariate
function like in the previous section there is an even more convenient way in
inlabru. Spatial covariates are often stored as \code{SpatialPixelsDataFrame},
\code{SpatialPixelsDataFrame} or \code{RasterLayer} objects. These can be provided
directly via the input expressions if they are supported by \code{\link[=eval_spatial]{eval_spatial()}},
and the \code{\link[=bru_obs]{bru_obs()}} data is an \code{sf} or \code{SpatialPointsDataFrame} object.
\code{inlabru} will then automatically evaluate and/or interpolate the covariate
at your data locations when using code like

\if{html}{\out{<div class="sourceCode">}}\preformatted{components = y ~ psi(mySpatialPixels, model = "linear")
}\if{html}{\out{</div>}}

For more precise control, use the the \code{layer} and \code{selector} arguments (see
\code{\link[=bru_comp]{bru_comp()}}), or call \code{\link[=eval_spatial]{eval_spatial()}} directly, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{components = y ~ psi(eval_spatial(mySpatialPixels, where = .data.),
                     model = "linear")
}\if{html}{\out{</div>}}
}

\section{Coordinates}{


A common spatial modelling component when using inla are SPDE models. An
important feature of inlabru is that it will automatically calculate the so
called A-matrix (a component model matrix) which maps SPDE values at the mesh
vertices to values at the data locations. For this purpose, the input can be
set to \code{coordinates}, which is the \code{sp} package function that extracts point
coordinates from the \code{SpatialPointsDataFrame} that was provided as input to
\code{\link[=bru_obs]{bru_obs()}}. The code for this would look as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{components = y ~ field(coordinates, model = inla.spde2.matern(...))
}\if{html}{\out{</div>}}

Since \code{coordinates} is a function from the \code{sp} package, this results in
evaluation of \code{sp::coordinates(.data.)}, which loses any CRS information
from the data object.

For \code{sf} data with a geometry column (by default named \code{geometry}), use

\if{html}{\out{<div class="sourceCode">}}\preformatted{components = y ~ field(geometry, model = inla.spde2.matern(...))
}\if{html}{\out{</div>}}

Since the CRS information is part of the geometry column of the \code{sf} object,
this retains CRS information, so this is more robust, and allows the model
to be built on a different CRS than the observation data.
}

\examples{
inp <- bru_input(expression(x), "LABEL")
bru_input(inp, data.frame(x = 1:3))
}
\seealso{
\code{\link[=summary.bru_input]{summary.bru_input()}}, \code{\link[=bru_comp]{bru_comp()}}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}, Finn Lindgren
\email{finn.lindgren@gmail.com}
}
\keyword{internal}
