% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_functions.R
\name{extract_variables_from_formula}
\alias{extract_variables_from_formula}
\title{Extract and group variables from formulas}
\usage{
extract_variables_from_formula(
  formula_moi,
  formula_imp,
  formula_mis = NULL,
  error_variable = NULL
)
}
\arguments{
\item{formula_moi}{an object of class "formula", describing the main model to be fitted.}

\item{formula_imp}{an object of class "formula", describing the imputation model for the mismeasured and/or missing observations.}

\item{formula_mis}{an object of class "formula", describing the missingness model. Does not need to have a response variable, since this will always be a binary missingness indicator.}

\item{error_variable}{character vector with the name(s) of the variable(s) with error.}
}
\value{
A list containing the names of the different variables of the model. The names of the elements in the list are "response_moi" (the response for the moi), "covariates_moi" (all covariates in the moi), "error_variable" (the name of the variable with error or missing data), "covariates_error_free" (the moi covariates without error), "response_imp" (imputation model response), "covariates_imp" (imputation model covariates).
}
\description{
Helper function that takes in the formulas for the model of interest and the
imputation model, and groups them into responses, covariates, covariate with
error and covariate(s) without error, for both sub-models.
}
\keyword{internal}
