% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varRplot.R
\name{varRplot}
\alias{varRplot}
\title{varRplot: Plot of Variance Ratio Estimate by Likelihood Method}
\usage{
varRplot(
  num.data,
  denom.data,
  logLRT = FALSE,
  conf.level = 0.95,
  df = 2.4,
  low.scale = 5,
  up.scale = 5,
  k
)
}
\arguments{
\item{num.data}{A numeric vector functioning as a sample data, in a numerator position.}

\item{denom.data}{A numeric vector functioning as a sample data, in a denominator position.}

\item{logLRT}{A function type to be plotted. A default value "FALSE" refers to the log-likelihood function plot, while "TRUE" refers to the normalized log-likelihood ratio plot, or maxLL-LL.}

\item{conf.level}{A confidence level for CI method.}

\item{df}{A degree of freedom for LI method in terms of the denominator degree of freedom of F-test, as (n-df) of LRT, where n is the sum of sample sizes of input datum. For a variance ratio estimation, it is suggested to be 2.4.}

\item{low.scale}{A scaling factor for plotting the minimum value of x-axis, or a parameter value. The plot starts from "PE/low.scale". 5 is a default.}

\item{up.scale}{A scaling factor for plotting the maximum value of x-axis, or a parameter value. The plot starts from "PE*up.scale". 5 is a default.}

\item{k}{A cutoff value for LI method. Unless specified, F-test is used.}
}
\value{
Plotted graph, either in the log-likelihood function or the normalized log-likelihood value
}
\description{
This function plots a graph of interval estimation for a two group variance ratio by LI method, either in the log-likelihood function or the normalized log-likelihood value.
}
\examples{
x <- rnorm(20, 0, 1)
y <- rnorm(40, 0, 1)
varRplot(x, y, FALSE)
varRplot(x, y, TRUE)

}
