% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanCI.R
\name{meanCI}
\alias{meanCI}
\title{Calculate confidence intervals of mean or difference between means}
\usage{
meanCI(x, ...)
}
\arguments{
\item{x}{An object of class data.frame or vector}

\item{...}{Further arguments}
}
\value{
An object of class "meanCI" which is a list containing at least the following components:
\describe{
  \item{data}{A tibble containing raw data or a list of numeric vector}
  \item{result}{A data.frame consist of summary statistics}
  \item{call}{the matched call}
  \item{attr(*,"measure")}{character. One of c("mean","unpaired","paired")}
}
}
\description{
Calculate confidence intervals of mean or difference between means
}
\examples{
meanCI(mtcars$mpg)
meanCI(n=150,m=115,s=10,alpha=0.01)
meanCI(n=50,m=295,s=20,mu=300)
meanCI(n=20,m=108,s=10,mu=110,alpha=0.01,alternative="less")
meanCI(mtcars,am,mpg)
meanCI(n1=15,n2=20,m1=1000,s1=100,m2=950,s2=90,alpha=0.1)
meanCI(n1=500,n2=1000,m1=20,s1=3,m2=15,s2=2,alpha=0.01)
meanCI(n1=30,n2=25,m1=78,s1=10,m2=85,s2=15,alpha=0.10)
meanCI(n1=100,n2=100,m1=200,s1=40,m2=190,s2=20,mu=7,alpha=0.05,alternative="greater")
x=c(3.04,2.92,2.86,1.71,3.60,3.49,3.30,2.28,3.11,2.88,2.82,2.13,2.11,3.03,3.27,2.60,3.13)
y=c(2.56,3.47,2.65,2.77,3.26,3.00,2.70,3.20,3.39,3.00,3.19,2.58,2.98)
meanCI(x=x,y=y)
x=c(95,89,76,92,91,53,67,88,75,85,90,85,87,85,85,68,81,84,71,46,75,80)
y=c(90,85,73,90,90,53,68,90,78,89,95,83,83,83,82,65,79,83,60,47,77,83)
meanCI(x=x,y=y,paired=TRUE,alpha=0.1)
meanCI(10:30,1:15)
meanCI(acs,sex,age)
meanCI(iris$Sepal.Width,iris$Sepal.Length)
meanCI(iris$Sepal.Width,iris$Sepal.Length,paired=TRUE)
}
