% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hac_covariance.R
\name{HACcovariance}
\alias{HACcovariance}
\title{Heteroskedasticity and Autocorrelation robust covariance estimator}
\usage{
HACcovariance(series, prewhite = FALSE, check_arguments = TRUE)
}
\arguments{
\item{series}{A matrix (or vector) of data where each column is a time series.}

\item{prewhite}{A boolean indicating if the series needs prewhitening by
fitting an AR(1). Default is \code{FALSE}}

\item{check_arguments}{A boolean \code{TRUE} for internal check of all function
arguments; \code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
A symmetric matrix (or a scalar if only one column series is provided)
representing the estimated HAC covariance.
}
\description{
This function estimates the long-run covariance matrix of a multivariate
centred time series accounting for heteroskedasticity and autocorrelation
using the Newey-West (1994)
\url{doi:10.2307/2297912} estimator.
The number is selected using the Newey-West plug-in procedure, where
\code{n_lags = 4 * (n_observations/100)^(2/9)}.
The function allows to internally prewhiten the series by fitting a VAR(1).
All the details can be found in Newey-West (1994)
\url{doi:10.2307/2297912}.
}
\examples{
# Import package data on 6 risk factors and 42 test asset excess returns
returns = intrinsicFRP::returns[,-1]
factors = intrinsicFRP::factors[,-1]

# Fit a linear model of returns on factors
fit = stats::lm(returns ~ factors)

# Extract residuals from the model
residuals = stats::residuals(fit)

# Compute the HAC covariance of the residuals
hac_covariance = HACcovariance(residuals)

# Compute the HAC covariance of the residuals imposing prewhitening
hac_covariance_pw = HACcovariance(residuals, prewhite = TRUE)

}
