\name{heatmap.CNA}
\alias{heatmap.CNA}
\title{
Visualization of Copy Number and CNA Calls
}
\description{
Heatmap visualization including optional hierarchical clustering of amplicons/genes and samples.
}
\usage{
heatmap.CNA(CNA, thres.percent=1, cluster.genes=TRUE, cluster.samples=TRUE,
type="CNA calls", method.dist="manhattan", method.link="average", mar=3, cex=0.50)
}
\arguments{
  \item{CNA}{
Indicator matrix of CNAs generated by \code{\link{call.CNA}}.
}
  \item{thres.percent}{
Number between 0 and 100. Only genes with a minimum percentage of
amplified and/or deleted samples are included into the heatmap.
}
  \item{cluster.genes}{
Logical value. If \code{TRUE} hierarchical cluster of genes is executed.
}
  \item{cluster.samples}{
Logical value. If \code{TRUE} hierarchical cluster of samples is executed.
}
 \item{type}{
Heatmap of copy numbers \code{"Copy Number"} or CNA calls \code{"CNA Calls"}.
}
  \item{method.dist}{
Character. Method for calculation of the distance between genes/amplicons and between samples.
}
  \item{method.link}{
Character. Linkage method to calculate the distance between clusters.
}
  \item{mar}{
Numeric value. Margins for row names and column names.
}
  \item{cex}{
Numerical value. Shrinkage factor for row names and column names.
}
}
\value{
Depending on \code{"type"} heatmap of CNAs (color coding: LOSS=green, NORMAL=black, GAIN=red) or
heatmap of copy numbers (color coding CN<1: green, CN<2: darkgreen, CN>3: darkred, CN>4: red, CN>5: orange, CN>10: yellow).
}
