% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\name{Queue}
\alias{Queue}
\alias{queue}
\title{A Class containing a producer and consumer}
\usage{
queue(
  source = defaultSource()$new(),
  producer = Producer$new(source),
  consumer = Consumer$new(source)
)
}
\arguments{
\item{source}{The source for reading and writing the queue}

\item{producer}{The producer for the source}

\item{consumer}{The consumer of the source}
}
\description{
Creates a Queue object for inter-process communication.
Its members \code{producer} and \code{consumer} are the main entry points for
sending and receiving messages respectively.
}
\details{
This function creates a queue object for communication between different R processes,
including forks of the same process.  By default, it uses \code{txtq} backage as its backend.
Technically, the information is sent through temporary files, created in a new directory
inside the session-specific temporary folder (see \code{\link{tempfile}}).
This requires that the new directory is writeable, this is normally the case but
if \code{\link{Sys.umask}} forbids writing, the communication fails with an error.
}
\examples{
\dontrun{
library(parallel)
library(future)
library(promises)
plan(multisession)

q <- queue()

# communicate from main session to child
fut <- future({
  for(i in 1:1000){
    Sys.sleep(.1)
    q$consumer$consume()
  }
})

q$producer$fireEval(stop("Stop that child"))
cat(try(value(fut)))

# Communicate from child to main session
j <- 0
fut <- future({
  for(i in 1:10){
    Sys.sleep(.2)

    # set j in the main thread substituting i into the expression
    q$producer$fireEval(j <- i, env=list(i=i))
  }
})

while(j < 10){
 q$consumer$consume() # collect and execute assignments
 cat("j = ", j, "\n")
 Sys.sleep(.1)
}

fut <- future({
  for(i in 1:10){
    Sys.sleep(.2)

    # set j in the main thread substituting i into the expression
    q$producer$fireEval(print(i), env=list(i=i))
  }
})

q$consumer$start() # execute `comsume` at regular intervals

# clean up
q$destroy()

}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{producer}}{A Producer object}

\item{\code{consumer}}{a Consumer object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Queue-new}{\code{Queue$new()}}
\item \href{#method-Queue-destroy}{\code{Queue$destroy()}}
\item \href{#method-Queue-clone}{\code{Queue$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-new"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-new}{}}}
\subsection{Method \code{new()}}{
Create a Queue object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$new(source, prod, cons)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{The source to use for communication.}

\item{\code{prod}}{A Producer object.}

\item{\code{cons}}{A Consumer object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-destroy}{}}}
\subsection{Method \code{destroy()}}{
clean up object after use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$destroy()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
