% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_and_predict.R
\name{predict}
\alias{predict}
\alias{fitted.ipriorMod}
\alias{predict.ipriorMod}
\alias{print.ipriorPredict}
\title{Obtain predicted values from \code{ipriorMod} objects}
\usage{
\method{fitted}{ipriorMod}(object, intervals = FALSE, alpha = 0.05, ...)

\method{predict}{ipriorMod}(
  object,
  newdata = list(),
  y.test = NULL,
  intervals = FALSE,
  alpha = 0.05,
  ...
)

\method{print}{ipriorPredict}(x, rows = 10, dp = 3, ...)
}
\arguments{
\item{object, x}{An \code{ipriorMod} object.}

\item{intervals}{Logical. Calculate the credibility intervals for the fitted
values. Defaults to \code{FALSE}.}

\item{alpha}{The significance level for the credibility intervals. This is a
number between 0 and 1.}

\item{...}{Not used.}

\item{newdata}{Either a data frame when using formula method, or a list of
vectors/matrices if using default method. Either way, the new data must be
structurally similar to the original data used to fit the model.}

\item{y.test}{(Optional) Test data, in order to compute test error rates.}

\item{rows}{(Optional) The number of values/rows to display.}

\item{dp}{(Optional) Decimal places for the values.}
}
\value{
A list of class \code{ipriorPredict} containing the fitted values,
  residuals (observed minus fitted), the training mean squared error, and the
  lower and upper intervals (if called).
}
\description{
Obtain predicted values from \code{ipriorMod} objects
}
\examples{
dat <- gen_smooth(20)
mod <- iprior(y ~ ., dat, kernel = "se")
fitted(mod)
fitted(mod, intervals = TRUE)
predict(mod, gen_smooth(5))

with(dat, mod <<- iprior(y, X, kernel = "poly"))
newdat <- gen_smooth(30)
mod.pred <- predict(mod, list(newdat$X), y.test = newdat$y, intervals = TRUE)
str(mod.pred)
print(mod.pred, row = 5)

}
