% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{icc2.nointer.fn}
\alias{icc2.nointer.fn}
\title{Intraclass Correlation Coefficients ICC(2,1) and ICCa(2,1) under ANOVA Model 2 without interaction.}
\usage{
icc2.nointer.fn(ratings)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (some duplicates are expected,
as some subject are assumed to have assigned multiple ratings) and each of the remaining columns is associated with a particular rater and
contains its numeric ratings.}
}
\value{
This function returns a list containing the following 11 values:\cr
1. sig2s: the subject variance component.\cr
2.sig2r: the rater variance component\cr
3. sig2e: the error variance component.\cr
4. icc2r: ICC as a measure of inter-rater relliability.\cr
5. icc2a: ICC as a measure of intra-rater reliability.\cr
6. n: the number of subjects.\cr
7. r: the number of raters.\cr
8. max.rep: the maximum number of ratings per subject.\cr
9. min.rep: the minimum number of ratings per subjects.\cr
10. M: the total number of ratings for all subjects and raters.\cr
11. ov.mean: the overall mean rating.
}
\description{
This function computes 2 Intraclass Correlation Coefficients (ICC) ICC(2,1) and ICCa(2,1) under the random factorial ANOVA model
(Model 2) without any subject-rater interaction. ICC(2,1) is formulated as a measure of inter-rater reliability and ICCa(2,1)
as a measure of intra-rater reliability.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
icc2.nointer.fn(iccdata1)
coeff <- icc2.nointer.fn(iccdata1)$icc2r #this only gives you the ICC coefficient
coeff
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} - Equations 9.5.2 and 9.5.3 of chapter 9, page 258.
Advanced Analytics, LLC.
}
