% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isdparser-package.R
\docType{data}
\name{isd_metadata}
\alias{isd_metadata}
\title{NOAA ISD metadata data.frame}
\format{A data frame with 643 rows and 19 columns}
\description{
This data.frame includes metadata describing all the data provided in ISD
data files. And is used for transforming and scaling variables.
}
\details{
Original csv data is in inst/extdata/isd_metadata.csv, collected from


The data.frame has the following columns:

\itemize{
 \item pos - (chr) position, if any
 \item category - (chr) category, one of additional-data section,
 control-data section, element quality data section, mandatory-data section,
 original observation data section, or remarks data section
 \item sub_category - (chr) sub category label, one of climate reference
 network unique data, cloud and solar data, ground surface data, hail data,
 marine data, network metadata, precipitation-data, pressure data,
 runway visual range data, sea surface temperature, soil temperature data,
 temperature data, weather occurrence data, weather-occurrence-data,
 or wind data
 \item abbrev - (chr) abbreviation, if any, NA for control and mandatory
 sections
 \item label - (chr) label, a top level label for the data, usually the
 same as the abbreviation
 \item sub_label - (chr) sub label, a more detailed label about the
 variable
 \item field_length - (int) field length, number of characters
 \item min - (chr) minimum value, if applicable, original
 \item min_numeric - (int) minimum value, if applicable, integer
 \item max - (chr) maximum value, if applicable, original
 \item max_numeric - (chr) maximum value, if applicable, integer
 \item units - (chr) units, if applicable
 \item scaling_factor - (chr) scaling factor, original
 \item scaling_factor_numeric - (int) scaling factor, integer, one of
 1, 10, 100, 1000, or NA
 \item missing - (chr) value used to indicate missing data, original
 \item missing_numeric - (int) value used to indicate missing data, integer,
 one of 9, 99, 999, 9999, 99999, 999999, or NA
 \item description - (chr) short description of variable
 \item dom - (chr) long description of variable with categories
 \item dom_parsed_json - (list) NA if no categories, or a named list with
 category labels and their values
}
}
\keyword{datasets}
